/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.autotools;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.zelythia.autotools.ItemMiningSpeed;
import net.zelythia.autotools.clientTags.ClientTags;
import net.zelythia.autotools.config.AutoToolsConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AutoTools {
    public static final String MOD_ID = "autotools";
    public static final Logger LOGGER = LogManager.getLogger((String)"AutoTools");
    public static final Set<class_2960> SILK_TOUCH = new HashSet<class_2960>();
    public static final Set<class_2960> SILK_TOUCH_SETTING_ALWAYS = new HashSet<class_2960>();
    public static final Set<class_2960> SILK_TOUCH_SETTING_ALWAYS_ORES = new HashSet<class_2960>();
    public static final Set<class_2960> SILK_TOUCH_SETTING_ALWAYS_EXC_ORES = new HashSet<class_2960>();
    public static final Set<class_2960> FORTUNE = new HashSet<class_2960>();
    public static final Set<class_2960> FORTUNE_SETTING = new HashSet<class_2960>();
    public static final Set<class_2960> SHEARS = new HashSet<class_2960>();
    public static final Set<class_2960> DO_NOT_SWAP_UNLESS_ENCH = new HashSet<class_2960>();
    public static final HashMap<class_2960, List<class_2960>> CUSTOM_TOOLS = new HashMap();
    public static final Stack<Integer> swaps = new Stack();
    public static boolean toggle = true;
    public static boolean startedMining = false;
    public static boolean swapped = false;

    public static void init() {
        AutoTools.reloadConfig();
    }

    public static void reloadConfig() {
        AutoToolsConfig.BlockLists lists = AutoToolsConfig.blockLists();
        AutoTools.createLists(lists.silktouch, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "shears")), SILK_TOUCH);
        AutoTools.createLists(lists.silktouch_setting_always, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "silk_touch_setting_always")), SILK_TOUCH_SETTING_ALWAYS);
        AutoTools.createLists(lists.silktouch_setting_always_ores, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "silk_touch_setting_always_ores")), SILK_TOUCH_SETTING_ALWAYS_ORES);
        AutoTools.createLists(lists.silktouch_setting_exc_ores, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "silk_touch_setting_always_exc_ores")), SILK_TOUCH_SETTING_ALWAYS_EXC_ORES);
        AutoTools.createLists(lists.fortune, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "fortune")), FORTUNE);
        AutoTools.createLists(lists.fortune_setting, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "fortune_setting")), FORTUNE_SETTING);
        AutoTools.createLists(lists.shears, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "shears")), SHEARS);
        AutoTools.createLists(lists.do_not_swap_unless_ench, (class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(MOD_ID, "do_not_swap_unless_ench")), DO_NOT_SWAP_UNLESS_ENCH);
        AutoTools.loadCustomItems();
        CUSTOM_TOOLS.computeIfAbsent(new class_2960("minecraft", "bamboo"), k -> new ArrayList()).addAll(ClientTags.getOrCreateLocalTag(class_3489.field_42611));
    }

    private static void createLists(List<String> input, class_6862<class_2248> tag, Set<class_2960> output) {
        output.clear();
        for (String identifier : input) {
            class_2960 resourceLocation;
            if (identifier.startsWith("#")) {
                resourceLocation = class_2960.method_12829((String)identifier.substring(1));
                if (resourceLocation == null) continue;
                output.addAll(ClientTags.getOrCreateLocalTag(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation)));
                continue;
            }
            resourceLocation = class_2960.method_12829((String)identifier);
            if (resourceLocation == null) continue;
            output.add(resourceLocation);
        }
        if (AutoToolsConfig.blockLists().enable_datapacks) {
            output.addAll(ClientTags.getOrCreateLocalTag(tag));
        }
    }

    private static void loadCustomItems() {
        CUSTOM_TOOLS.clear();
        try {
            JsonElement jsonElement = JsonParser.parseString((String)("{" + AutoToolsConfig.blockLists().customTools.stream().reduce((s, s2) -> s + ", " + s2).orElse("") + "}"));
            if (!jsonElement.isJsonObject()) {
                return;
            }
            JsonObject jsonObject = (JsonObject)jsonElement;
            for (String key : jsonObject.keySet()) {
                ArrayList<class_2960> tools = new ArrayList<class_2960>();
                if (jsonObject.get(key).isJsonArray()) {
                    JsonArray toolsArray = jsonObject.getAsJsonArray(key);
                    for (int i = 0; i < toolsArray.size(); ++i) {
                        String tool = toolsArray.get(i).getAsString();
                        if (tool.startsWith("#")) {
                            class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tool.substring(1)));
                            Set<class_2960> tag = ClientTags.getOrCreateLocalTag(tagKey);
                            tools.addAll(tag);
                            continue;
                        }
                        tools.add(new class_2960(tool));
                    }
                } else {
                    String tool = jsonObject.get(key).getAsString();
                    if (tool.startsWith("#")) {
                        class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)new class_2960(tool.substring(1)));
                        Set<class_2960> tag = ClientTags.getOrCreateLocalTag(tagKey);
                        tools.addAll(tag);
                    } else {
                        tools.add(new class_2960(tool));
                    }
                }
                if (key.startsWith("#")) {
                    class_6862 blockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(key.substring(1)));
                    Set<class_2960> tag = ClientTags.getOrCreateLocalTag(blockTagKey);
                    tag.forEach(resourceLocation -> CUSTOM_TOOLS.computeIfAbsent((class_2960)resourceLocation, k -> new ArrayList()).addAll(tools));
                    continue;
                }
                CUSTOM_TOOLS.computeIfAbsent(new class_2960(key), k -> new ArrayList()).addAll(tools);
            }
            LOGGER.info("Loaded custom block configs: " + String.valueOf(CUSTOM_TOOLS.keySet()));
        }
        catch (Exception e) {
            LOGGER.error("Error while parsing custom blocks", (Throwable)e);
        }
    }

    public static void onBlockBreaking(class_310 client, class_239 hitResult) {
        if (AutoToolsConfig.get().toggle && toggle) {
            if (client.field_1724.method_7337()) {
                if (!AutoToolsConfig.get().disableCreative) {
                    AutoTools.getCorrectTool(hitResult, client);
                }
            } else {
                AutoTools.getCorrectTool(hitResult, client);
            }
        }
    }

    public static void selectItem(class_310 client, class_1661 inventory, int sourceSlot) {
        int destSlot;
        if (sourceSlot == inventory.field_7545) {
            return;
        }
        if (swaps.empty()) {
            swaps.push(inventory.field_7545);
        }
        if (sourceSlot <= 8 && !AutoToolsConfig.get().keepSlot) {
            if ((Integer)swaps.get(swaps.size() - 1) != inventory.field_7545 && swaps.peek() != sourceSlot) {
                swaps.push(inventory.field_7545);
            }
            inventory.field_7545 = sourceSlot;
            return;
        }
        if (sourceSlot <= 8) {
            sourceSlot += 36;
        }
        int n = destSlot = AutoToolsConfig.get().keepSlot ? inventory.field_7545 : AutoTools.getSuitableHotbarSlot(inventory);
        if (!AutoToolsConfig.get().targetSlots.contains(destSlot + 1)) {
            destSlot = AutoToolsConfig.get().targetSlots.get(0) - 1;
        }
        if (swaps.peek() != sourceSlot) {
            swaps.push(sourceSlot);
        }
        if (swaps.peek() != destSlot) {
            swaps.push(destSlot);
        }
        swapped = true;
        client.field_1761.method_2906(client.field_1724.field_7498.field_7763, sourceSlot, destSlot, class_1713.field_7791, (class_1657)client.field_1724);
        inventory.field_7545 = destSlot;
        inventory.method_5431();
        if (!AutoToolsConfig.get().switchBack) {
            swaps.clear();
        }
    }

    public static int getSuitableHotbarSlot(class_1661 inventory) {
        int j;
        int i;
        for (i = 0; i < 9; ++i) {
            j = (inventory.field_7545 + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || !((class_1799)inventory.field_7547.get(j)).method_7960()) continue;
            return j;
        }
        for (i = 0; i < 9; ++i) {
            j = (inventory.field_7545 + i) % 9;
            if (!AutoToolsConfig.get().targetSlots.contains(j + 1) || ((class_1799)inventory.field_7547.get(j)).method_7942()) continue;
            return j;
        }
        return inventory.field_7545;
    }

    public static void switchBack() {
        if (!AutoToolsConfig.get().switchBack) {
            return;
        }
        if (class_310.method_1551().field_1690.field_1886.method_1434() || swaps.empty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1761 == null) {
            return;
        }
        class_1661 inventory = client.field_1724.method_31548();
        boolean changed = true;
        block0: while (changed && swaps.size() > 1) {
            changed = false;
            for (int intervalSize = swaps.size() / 2; intervalSize >= 2; --intervalSize) {
                for (int topOffset = 0; topOffset <= swaps.size() / intervalSize; ++topOffset) {
                    boolean foundDuplicate = true;
                    if (swaps.size() - 1 - topOffset >= 2 * intervalSize) {
                        for (int j = topOffset; j < intervalSize + topOffset; ++j) {
                            if (swaps.elementAt(swaps.size() - j - 1) == swaps.elementAt(swaps.size() - 1 - intervalSize - j)) continue;
                            foundDuplicate = false;
                            break;
                        }
                    } else {
                        foundDuplicate = false;
                    }
                    if (!foundDuplicate) continue;
                    int initialSize = swaps.size();
                    for (int i = 0; i < intervalSize * 2; ++i) {
                        swaps.remove(initialSize - topOffset - intervalSize * 2);
                    }
                    changed = true;
                    continue block0;
                }
            }
        }
        while (!swaps.empty()) {
            int i = swaps.pop();
            if (i <= 8) {
                if (AutoToolsConfig.get().keepSlot && i != inventory.field_7545) {
                    client.field_1761.method_2906(client.field_1724.field_7498.field_7763, inventory.field_7545, i, class_1713.field_7791, (class_1657)client.field_1724);
                    return;
                }
                inventory.field_7545 = i;
                return;
            }
            client.field_1761.method_2906(client.field_1724.field_7498.field_7763, i, inventory.field_7545, class_1713.field_7791, (class_1657)client.field_1724);
        }
        inventory.method_5431();
    }

    public static ItemMiningSpeed getMiningSpeed(class_1799 stack, class_2680 blockState, class_2338 pos) {
        float modifier = 1.0f;
        int priority = 0;
        float miningSpeed = stack.method_7924(blockState);
        if (stack.method_7942()) {
            if (blockState.method_26214(null, pos) != 0.0f && stack.method_7951(blockState)) {
                modifier += (float)class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack) * 20.0f / 100.0f;
            }
            if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) == 1) {
                if (SILK_TOUCH.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.always && SILK_TOUCH_SETTING_ALWAYS.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.except_ores && SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) || AutoToolsConfig.get().preferSilkTouch == AutoToolsConfig.PreferSilkTouch.ores && SILK_TOUCH_SETTING_ALWAYS_ORES.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
                    priority = 6;
                }
            } else if (class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack) >= 1) {
                if (FORTUNE.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) || AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
                    priority += class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack);
                }
                if (AutoToolsConfig.get().alwaysPreferFortune && FORTUNE_SETTING.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
                    priority += 6;
                }
            }
            if (FORTUNE.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && DO_NOT_SWAP_UNLESS_ENCH.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && ClientTags.isInWithLocalFallback(class_3489.field_42613, stack.method_7909())) {
                ++priority;
            }
        }
        if (blockState.method_26214(null, pos) != 0.0f && miningSpeed > 1.0f) {
            if (class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) == 0 && !SILK_TOUCH.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && (SILK_TOUCH_SETTING_ALWAYS_EXC_ORES.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.except_ores || SILK_TOUCH_SETTING_ALWAYS_ORES.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.ores || SILK_TOUCH_SETTING_ALWAYS.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && AutoToolsConfig.get().preferSilkTouch != AutoToolsConfig.PreferSilkTouch.always)) {
                ++priority;
            }
            if (class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack) == 0 && !FORTUNE.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && FORTUNE_SETTING.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && !AutoToolsConfig.get().alwaysPreferFortune) {
                ++priority;
            }
        }
        if (stack.method_31574(class_1802.field_8868) && SHEARS.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
            priority += 6;
        }
        return new ItemMiningSpeed(Float.valueOf(miningSpeed * modifier), priority);
    }

    public static int findSlotMatchingItem(class_1661 inventory, class_1799 itemStack) {
        for (int i = 0; i < inventory.field_7547.size(); ++i) {
            if (!class_1799.method_7984((class_1799)itemStack, (class_1799)((class_1799)inventory.field_7547.get(i)))) continue;
            return i;
        }
        return -1;
    }

    public static boolean checkDurability(class_1799 stack) {
        double durability;
        return !(AutoToolsConfig.get().minDurability < 1.0 ? (durability = (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936()) < AutoToolsConfig.get().minDurability : (double)(stack.method_7936() - stack.method_7919()) <= AutoToolsConfig.get().minDurability);
    }

    public static void getCorrectTool(class_239 hit, class_310 client) {
        class_1661 inventory = client.field_1724.method_31548();
        if (AutoToolsConfig.get().ignoredSlots.contains(inventory.field_7545 + 1)) {
            return;
        }
        if (hit.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)hit;
            class_2680 blockState = client.field_1687.method_8320(blockHitResult.method_17777());
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.tool && !(AutoTools.getMiningSpeed((class_1799)inventory.method_7391(), (class_2680)blockState, (class_2338)blockHitResult.method_17777()).miningSpeed.floatValue() > 1.0f) && !inventory.method_7391().method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23721)) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.no_tool && (AutoTools.getMiningSpeed((class_1799)inventory.method_7391(), (class_2680)blockState, (class_2338)blockHitResult.method_17777()).miningSpeed.floatValue() > 1.0f || inventory.method_7391().method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23721))) {
                return;
            }
            int toolSlot = -1;
            ItemMiningSpeed miningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
            if (CUSTOM_TOOLS.containsKey(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
                List<class_2960> tools = CUSTOM_TOOLS.get(class_7923.field_41175.method_10221((Object)blockState.method_26204()));
                for (class_2960 resourceLocation : tools) {
                    if (Objects.equals(resourceLocation, new class_2960(MOD_ID, "disabled"))) {
                        return;
                    }
                    toolSlot = AutoTools.findSlotMatchingItem(inventory, new class_1799((class_1935)class_7923.field_41178.method_10223(resourceLocation)));
                    if (toolSlot == -1) continue;
                    break;
                }
                if (toolSlot != -1) {
                    AutoTools.selectItem(client, inventory, toolSlot);
                    return;
                }
            }
            if (!AutoToolsConfig.get().toggle && blockState.method_26204() == class_2246.field_10398 && (toolSlot = AutoTools.findSlotMatchingItem(inventory, new class_1799((class_1935)class_1802.field_8449))) != -1) {
                if (toolSlot <= 8) {
                    inventory.field_7545 = toolSlot;
                    return;
                }
                AutoTools.selectItem(client, inventory, toolSlot);
                return;
            }
            if (blockState.method_26214(null, blockHitResult.method_17777()) == 0.0f && !DO_NOT_SWAP_UNLESS_ENCH.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204()))) {
                return;
            }
            if (AutoToolsConfig.get().onlySwitchIfNecessary && (inventory.method_5438(inventory.field_7545).method_7951(blockState) || !blockState.method_29291())) {
                return;
            }
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1792 item = inventory.method_5438(i).method_7909();
                if (item == class_1802.field_8162) continue;
                ItemMiningSpeed newMiningSpeed = new ItemMiningSpeed(Float.valueOf(1.0f), 0);
                if (item.method_7856(blockState) || !blockState.method_29291()) {
                    if (!AutoTools.checkDurability(inventory.method_5438(i))) continue;
                    newMiningSpeed = AutoTools.getMiningSpeed(inventory.method_5438(i), blockState, blockHitResult.method_17777());
                }
                if (newMiningSpeed.equals(miningSpeed)) {
                    if (toolSlot == -1) continue;
                    if (AutoToolsConfig.get().preferHotbarTool) {
                        if (i > 8 || toolSlot <= 8 && i != inventory.field_7545 && (!AutoToolsConfig.get().preferLowDurability || inventory.method_5438(i).method_7919() <= inventory.method_5438(toolSlot).method_7919()) && (AutoToolsConfig.get().preferLowDurability || inventory.method_5438(i).method_7919() >= inventory.method_5438(toolSlot).method_7919())) continue;
                        toolSlot = i;
                        miningSpeed = newMiningSpeed;
                        continue;
                    }
                    if ((!AutoToolsConfig.get().preferLowDurability || inventory.method_5438(i).method_7919() <= inventory.method_5438(toolSlot).method_7919()) && (AutoToolsConfig.get().preferLowDurability || inventory.method_5438(i).method_7919() >= inventory.method_5438(toolSlot).method_7919())) continue;
                    toolSlot = i;
                    miningSpeed = newMiningSpeed;
                    continue;
                }
                if (newMiningSpeed.priority <= miningSpeed.priority && (!(newMiningSpeed.miningSpeed.floatValue() > miningSpeed.miningSpeed.floatValue()) || newMiningSpeed.priority < miningSpeed.priority)) continue;
                toolSlot = i;
                miningSpeed = newMiningSpeed;
            }
            if (!(toolSlot == -1 || DO_NOT_SWAP_UNLESS_ENCH.contains(class_7923.field_41175.method_10221((Object)blockState.method_26204())) && miningSpeed.priority == 0)) {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        } else if (AutoToolsConfig.get().changeForEntities && hit.method_17783() == class_239.class_240.field_1331) {
            if (AutoToolsConfig.get().switchBack) {
                return;
            }
            class_1297 entity = ((class_3966)hit).method_17782();
            if (AutoToolsConfig.get().keepAxe && ClientTags.isInWithLocalFallback(class_3489.field_42612, inventory.method_7391().method_7909())) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.tool && !inventory.method_7391().method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23721)) {
                return;
            }
            if (AutoToolsConfig.get().enabled == AutoToolsConfig.Enabled.no_tool && inventory.method_7391().method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23721)) {
                return;
            }
            int toolSlot = -1;
            float attackDamage = 0.0f;
            for (int i = 0; i < inventory.method_5439(); ++i) {
                class_1297 class_12972;
                class_1309 livingEntity;
                class_1792 item = inventory.method_5438(i).method_7909();
                if (item == class_1802.field_8162) continue;
                double newAttackDamage = 1.0;
                if (!(entity instanceof class_1690) && !(entity instanceof class_1688) && !(entity instanceof class_1309)) continue;
                if (entity instanceof class_1309) {
                    livingEntity = (class_1309)entity;
                    if (!item.method_7873(inventory.method_5438(i), livingEntity, (class_1309)inventory.field_7546)) continue;
                }
                if (CUSTOM_TOOLS.containsKey(class_7923.field_41177.method_10221((Object)entity.method_5864()))) {
                    List<class_2960> tools = CUSTOM_TOOLS.get(class_7923.field_41177.method_10221((Object)entity.method_5864()));
                    class_12972 = tools.iterator();
                    while (class_12972.hasNext()) {
                        class_2960 resourceLocation = class_12972.next();
                        if (Objects.equals(resourceLocation, new class_2960(MOD_ID, "disabled"))) {
                            return;
                        }
                        toolSlot = AutoTools.findSlotMatchingItem(inventory, new class_1799((class_1935)class_7923.field_41178.method_10223(resourceLocation)));
                        if (toolSlot == -1) continue;
                        break;
                    }
                    if (toolSlot != -1) {
                        AutoTools.selectItem(client, inventory, toolSlot);
                        return;
                    }
                }
                if (!AutoTools.checkDurability(inventory.method_5438(i))) continue;
                if (inventory.method_5438(i).method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23721)) {
                    newAttackDamage = inventory.method_5438(i).method_7926(class_1304.field_6173).containsKey((Object)class_5134.field_23723) ? (1.0 + ((class_1322)inventory.method_5438(i).method_7926(class_1304.field_6173).get((Object)class_5134.field_23721).toArray()[0]).method_6186()) * (4.0 + ((class_1322)inventory.method_5438(i).method_7926(class_1304.field_6173).get((Object)class_5134.field_23723).toArray()[0]).method_6186()) : 1.0 + ((class_1322)inventory.method_5438(i).method_7926(class_1304.field_6173).get((Object)class_5134.field_23721).toArray()[0]).method_6186();
                }
                if (inventory.method_5438(i).method_7942() && (class_12972 = ((class_3966)hit).method_17782()) instanceof class_1309) {
                    livingEntity = (class_1309)class_12972;
                    newAttackDamage += (double)class_1890.method_8218((class_1799)inventory.method_5438(i), (class_1310)livingEntity.method_6046());
                }
                if (newAttackDamage > (double)attackDamage || newAttackDamage == (double)attackDamage && toolSlot != -1 && inventory.method_5438(i).method_7919() < inventory.method_5438(toolSlot).method_7919()) {
                    attackDamage = (float)newAttackDamage;
                    toolSlot = i;
                    continue;
                }
                if (newAttackDamage != (double)attackDamage || inventory.method_5438(i).method_7919() <= inventory.method_5438(toolSlot).method_7919()) continue;
                toolSlot = i;
            }
            if (toolSlot == -1) {
                if (!AutoToolsConfig.get().toggle && client.field_1724.method_7337()) {
                    inventory.method_5447(inventory.method_7386(), new class_1799((class_1935)class_1802.field_22022));
                }
            } else {
                AutoTools.selectItem(client, inventory, toolSlot);
            }
        }
    }
}

