/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.TickEvent;
import net.countered.floatingtreedecay.BlockBreakLogic;
import net.countered.floatingtreedecay.DecayManager;
import net.countered.floatingtreedecay.persistence.ChunkLogPositionsAttachmentAccess;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.player.Player;

public final class ExampleMod {
    public static final String MOD_ID = "floating_tree_decay";
    public static ChunkLogPositionsAttachmentAccess ATTACHMENT_ACCESS;

    public static void init() {
        BlockEvent.PLACE.register((level, blockPos, blockState, entity) -> {
            if (blockState.is(BlockTags.LOGS) && entity instanceof Player && !level.isClientSide()) {
                ATTACHMENT_ACCESS.markPlayerPlaced(level, blockPos);
                System.out.println("placed block at: " + String.valueOf(blockPos) + " by player: " + entity.getName().getString());
            }
            return EventResult.pass();
        });
        BlockEvent.BREAK.register((level, blockPos, blockState, player, xp) -> {
            if (!level.isClientSide()) {
                if (ATTACHMENT_ACCESS.isPlayerPlaced(level, blockPos)) {
                    ATTACHMENT_ACCESS.unmarkPlayerPlaced(level, blockPos);
                    System.out.println("block at " + String.valueOf(blockPos) + " was placed by player, skipping decay logic.");
                    return EventResult.pass();
                }
                BlockBreakLogic.onBlockBroken(level, blockPos, blockState);
                System.out.println("broke block at: " + String.valueOf(blockPos) + " by player: " + player.getName().getString());
            }
            return EventResult.pass();
        });
        TickEvent.SERVER_POST.register(level -> DecayManager.tickAll());
    }
}

