/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay.forge.persistence;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.countered.floatingtreedecay.persistence.ChunkLogPositionsAttachmentAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class ForgePlayerPlacedLogProtection
implements ChunkLogPositionsAttachmentAccess {
    public static Capability<PlayerLogData> PLAYER_LOG_CAPABILITY;

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(PlayerLogData.class);
    }

    public static void attachChunkCapability(AttachCapabilitiesEvent<LevelChunk> event) {
        event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"floating_tree_decay", (String)"player_log_positions"), (ICapabilityProvider)new PlayerLogProvider());
    }

    private static PlayerLogData getData(Level level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        return (PlayerLogData)chunk.getCapability(PLAYER_LOG_CAPABILITY).orElseThrow(() -> new IllegalStateException("Could not find capability for player log positions"));
    }

    @Override
    public void markPlayerPlaced(Level level, BlockPos pos) {
        ForgePlayerPlacedLogProtection.getData(level, pos).add(pos);
    }

    @Override
    public boolean isPlayerPlaced(Level level, BlockPos pos) {
        return ForgePlayerPlacedLogProtection.getData(level, pos).contains(pos);
    }

    @Override
    public void unmarkPlayerPlaced(Level level, BlockPos pos) {
        ForgePlayerPlacedLogProtection.getData(level, pos).remove(pos);
    }

    public static void init(IEventBus modBus) {
        modBus.addListener(ForgePlayerPlacedLogProtection::registerCapabilities);
        MinecraftForge.EVENT_BUS.addGenericListener(LevelChunk.class, ForgePlayerPlacedLogProtection::attachChunkCapability);
    }

    public static class PlayerLogData {
        private final List<BlockPos> playerLogs = new ArrayList<BlockPos>();

        public void add(BlockPos pos) {
            this.playerLogs.add(pos);
        }

        public void remove(BlockPos pos) {
            this.playerLogs.remove(pos);
        }

        public boolean contains(BlockPos pos) {
            return this.playerLogs.contains(pos);
        }

        public List<BlockPos> getAll() {
            return new ArrayList<BlockPos>(this.playerLogs);
        }

        public void load(ListTag tag) {
            this.playerLogs.clear();
            for (Tag t : tag) {
                this.playerLogs.add(BlockPos.f_121852_.parse((DynamicOps)NbtOps.f_128958_, (Object)t).result().orElse(BlockPos.f_121853_));
            }
        }

        public ListTag save() {
            ListTag list = new ListTag();
            for (BlockPos pos : this.playerLogs) {
                BlockPos.f_121852_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)pos).result().ifPresent(arg_0 -> list.add(arg_0));
            }
            return list;
        }
    }

    public static class PlayerLogProvider
    implements ICapabilityProvider {
        private final PlayerLogData data = new PlayerLogData();
        private final LazyOptional<PlayerLogData> optional = LazyOptional.of(() -> this.data);

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            return cap == PLAYER_LOG_CAPABILITY ? this.optional.cast() : LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128365_("positions", (Tag)this.data.save());
            return tag;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.data.load(nbt.m_128437_("positions", 10));
        }
    }
}

