/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay;

import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DecayConfig {
    public static final ModConfigSpec CONFIG_SPEC;
    public static final DecayConfig CONFIG;
    public final ModConfigSpec.IntValue decaySpeed;
    public final ModConfigSpec.IntValue maxTreeSize;
    public final ModConfigSpec.BooleanValue enableParticles;

    DecayConfig(ModConfigSpec.Builder builder) {
        builder.push("floating_tree_decay");
        this.decaySpeed = builder.comment("How many ticks between log decay operations").defineInRange("decaySpeed", 0, 0, 1000);
        this.maxTreeSize = builder.comment("How many logs can be in a tree before it won't decay").defineInRange("maxTreeSize", 128, 0, 1000);
        this.enableParticles = builder.comment("Logs emit particles & sound when they decay").define("enableParticles", true);
        builder.pop();
    }

    static {
        Pair pair = new ModConfigSpec.Builder().configure(DecayConfig::new);
        CONFIG = (DecayConfig)pair.getLeft();
        CONFIG_SPEC = (ModConfigSpec)pair.getRight();
    }
}

