/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.countered.floatingtreedecay.DecayManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FloatingTree {
    Level level;
    BlockPos treePos;
    BlockState state;
    Set<BlockPos> logPositions = new HashSet<BlockPos>();
    private final int tickOffset;
    private int tickCount = this.tickOffset = new Random().nextInt(20);
    private static final int breakDelay = 100;

    public FloatingTree(Level level, BlockPos treePos, BlockState state) {
        this.level = level;
        this.treePos = treePos;
        this.state = state;
    }

    public void startDecay() {
        if (this.isFloatingTree()) {
            DecayManager.add(this);
        }
    }

    private boolean isFloatingTree() {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        this.logPositions.add(this.treePos);
        queue.add(this.treePos.m_7494_());
        int maxChecked = 100;
        int checked = 0;
        while (!queue.isEmpty() && checked < 100) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (!this.logPositions.add(currentPos)) continue;
            ++checked;
            BlockState currentState = this.level.m_8055_(currentPos);
            if (!currentState.m_204336_(BlockTags.f_13106_)) {
                return false;
            }
            for (BlockPos offset : BlockPos.m_121976_((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
                BlockPos next = currentPos.m_121955_((Vec3i)offset);
                BlockState nextState = this.level.m_8055_(next);
                if (this.logPositions.contains(next) || nextState.m_60795_() || nextState.m_204336_(BlockTags.f_13035_) || nextState.m_247087_()) continue;
                queue.add(next);
            }
        }
        this.logPositions.remove(this.treePos);
        return true;
    }

    public boolean tick() {
        if (this.logPositions.isEmpty()) {
            return false;
        }
        if (this.tickCount < 100) {
            ++this.tickCount;
            return true;
        }
        this.tickCount = 0;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.logPositions);
        Random random = new Random();
        BlockPos targetPos = (BlockPos)list.get(random.nextInt(list.size()));
        if (!this.level.m_46749_(targetPos)) {
            return false;
        }
        BlockState targetState = this.level.m_8055_(targetPos);
        Block.m_49950_((BlockState)targetState, (Level)this.level, (BlockPos)targetPos);
        this.level.m_7471_(targetPos, false);
        this.logPositions.remove(targetPos);
        return !this.logPositions.isEmpty();
    }
}

