/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.countered.floatingtreedecay.DecayConfig;
import net.countered.floatingtreedecay.DecayManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class FloatingTree {
    Level level;
    BlockPos treePos;
    BlockState state;
    Set<BlockPos> logPositions = new HashSet<BlockPos>();
    private final int tickOffset;
    private int tickCount = this.tickOffset = new Random().nextInt(20);

    public FloatingTree(Level level, BlockPos treePos, BlockState state) {
        this.level = level;
        this.treePos = treePos;
        this.state = state;
    }

    public void startDecay() {
        if (this.isFloatingTree()) {
            DecayManager.add(this);
        }
    }

    private boolean isFloatingTree() {
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>();
        this.logPositions.add(this.treePos);
        queue.add(this.treePos.above());
        int checked = 0;
        while (!queue.isEmpty() && checked < (Integer)DecayConfig.CONFIG.maxTreeSize.get()) {
            BlockPos currentPos = (BlockPos)queue.poll();
            if (!this.logPositions.add(currentPos)) continue;
            ++checked;
            BlockState currentState = this.level.getBlockState(currentPos);
            if (!currentState.is(BlockTags.LOGS)) {
                return false;
            }
            for (BlockPos offset : BlockPos.betweenClosed((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
                BlockPos next = currentPos.offset((Vec3i)offset);
                BlockState nextState = this.level.getBlockState(next);
                if (this.logPositions.contains(next) || nextState.isAir() || nextState.is(BlockTags.LEAVES) || nextState.canBeReplaced()) continue;
                queue.add(next);
            }
        }
        this.logPositions.remove(this.treePos);
        return true;
    }

    public boolean tick() {
        if (this.logPositions.isEmpty()) {
            return false;
        }
        if (this.tickCount < (Integer)DecayConfig.CONFIG.decaySpeed.get()) {
            ++this.tickCount;
            return true;
        }
        this.tickCount = 0;
        ArrayList<BlockPos> list = new ArrayList<BlockPos>(this.logPositions);
        Random random = new Random();
        BlockPos targetPos = (BlockPos)list.get(random.nextInt(list.size()));
        if (!this.level.isLoaded(targetPos)) {
            return false;
        }
        if (((Boolean)DecayConfig.CONFIG.enableParticles.get()).booleanValue()) {
            this.level.destroyBlock(targetPos, true);
        } else {
            BlockState targetState = this.level.getBlockState(targetPos);
            Block.dropResources((BlockState)targetState, (Level)this.level, (BlockPos)targetPos);
            this.level.removeBlock(targetPos, false);
        }
        this.logPositions.remove(targetPos);
        return !this.logPositions.isEmpty();
    }
}

