/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.countered.floatingtreedecay.DecayManager;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class FloatingTree {
    class_1937 level;
    class_2338 treePos;
    class_2680 state;
    Set<class_2338> logPositions = new HashSet<class_2338>();
    private final int tickOffset;
    private int tickCount = this.tickOffset = new Random().nextInt(20);
    private static final int breakDelay = 100;

    public FloatingTree(class_1937 level, class_2338 treePos, class_2680 state) {
        this.level = level;
        this.treePos = treePos;
        this.state = state;
    }

    public void startDecay() {
        if (this.isFloatingTree()) {
            DecayManager.add(this);
        } else {
            System.out.println("Tree at " + String.valueOf(this.treePos) + " is connected to the ground");
        }
    }

    private boolean isFloatingTree() {
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        this.logPositions.add(this.treePos);
        queue.add(this.treePos.method_10084());
        int maxChecked = 100;
        int checked = 0;
        while (!queue.isEmpty() && checked < 100) {
            class_2338 currentPos = (class_2338)queue.poll();
            if (!this.logPositions.add(currentPos)) continue;
            ++checked;
            class_2680 currentState = this.level.method_8320(currentPos);
            if (!currentState.method_26164(class_3481.field_15475)) {
                System.out.println("Connected to ground at " + String.valueOf(currentPos));
                return false;
            }
            for (class_2338 offset : class_2338.method_10094((int)-1, (int)-1, (int)-1, (int)1, (int)1, (int)1)) {
                class_2338 next = currentPos.method_10081((class_2382)offset);
                class_2680 nextState = this.level.method_8320(next);
                if (this.logPositions.contains(next) || nextState.method_26215() || nextState.method_26164(class_3481.field_15503) || nextState.method_45474()) continue;
                queue.add(next);
            }
        }
        this.logPositions.remove(this.treePos);
        System.out.println("Checked " + checked + " positions for connection to ground from " + String.valueOf(this.treePos));
        return true;
    }

    public boolean tick() {
        if (this.logPositions.isEmpty()) {
            return false;
        }
        if (this.tickCount < 100) {
            ++this.tickCount;
            return true;
        }
        this.tickCount = 0;
        ArrayList<class_2338> list = new ArrayList<class_2338>(this.logPositions);
        Random random = new Random();
        class_2338 targetPos = (class_2338)list.get(random.nextInt(list.size()));
        if (!this.level.method_8477(targetPos)) {
            System.out.println("unloaded");
            return false;
        }
        class_2680 targetState = this.level.method_8320(targetPos);
        class_2248.method_9497((class_2680)targetState, (class_1937)this.level, (class_2338)targetPos);
        this.level.method_8650(targetPos, false);
        System.out.println("destroyed log at " + String.valueOf(targetPos));
        this.logPositions.remove(targetPos);
        return !this.logPositions.isEmpty();
    }
}

