/*
 * Decompiled with CFR 0.152.
 */
package net.countered.floatingtreedecay.neoforge.persistence;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.countered.floatingtreedecay.persistence.ChunkLogPositionsAttachmentAccess;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;

public class NeoForgePlayerPlacedLogProtection
implements ChunkLogPositionsAttachmentAccess {
    public static final DeferredRegister<AttachmentType<?>> ATTACHMENTS = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"floating_tree_decay");
    public static final Supplier<AttachmentType<List<BlockPos>>> PLAYER_LOG_POSITIONS = ATTACHMENTS.register("player_log_positions", () -> AttachmentType.builder(() -> new ArrayList()).serialize(Codec.list((Codec)BlockPos.CODEC)).build());

    public static void init(IEventBus modEventBus) {
        ATTACHMENTS.register(modEventBus);
    }

    @Override
    public void markPlayerPlaced(Level level, BlockPos pos) {
        ChunkAccess chunk = level.getChunk(pos);
        ArrayList<BlockPos> list = new ArrayList<BlockPos>((Collection)chunk.getData(PLAYER_LOG_POSITIONS.get()));
        list.add(pos);
        chunk.setData(PLAYER_LOG_POSITIONS.get(), list);
    }

    @Override
    public boolean isPlayerPlaced(Level level, BlockPos pos) {
        ChunkAccess chunk = level.getChunk(pos);
        return ((List)chunk.getData(PLAYER_LOG_POSITIONS.get())).contains(pos);
    }

    @Override
    public void unmarkPlayerPlaced(Level level, BlockPos pos) {
        ChunkAccess chunk = level.getChunk(pos);
        ArrayList list = new ArrayList((Collection)chunk.getData(PLAYER_LOG_POSITIONS.get()));
        list.remove(pos);
        chunk.setData(PLAYER_LOG_POSITIONS.get(), list);
    }
}

