/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.gui;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.gui.ConfigRawScreen;
import io.github.kituin.chatimage.gui.LimitPaddingScreen;
import io.github.kituin.chatimage.widget.GifSlider;
import io.github.kituin.chatimage.widget.TimeOutSlider;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigScreen
extends ConfigRawScreen {
    public ConfigScreen(Screen screen) {
        super((Component)Component.translatable((String)"config.chatimage.category"), screen);
    }

    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getNsfw(ChatImage.CONFIG.nsfw), p_96270_ -> {
            ChatImage.CONFIG.nsfw = !ChatImage.CONFIG.nsfw;
            p_96270_.setMessage((Component)this.getNsfw(ChatImage.CONFIG.nsfw));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 - 154, this.height / 4 + 24 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"nsfw.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)new GifSlider(this.width / 2 + 4, this.height / 4 + 24 - 16, 150, 20, this.createSliderTooltip(GifSlider.tooltip())));
        this.addRenderableWidget((GuiEventListener)new TimeOutSlider(this.width / 2 - 154, this.height / 4 + 48 - 16, 150, 20, this.createSliderTooltip(TimeOutSlider.tooltip())));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"padding.chatimage.gui"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen((Screen)new LimitPaddingScreen(this));
            }
        }).bounds(this.width / 2 + 4, this.height / 4 + 48 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"padding.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getCq(ChatImage.CONFIG.cqCode), button -> {
            ChatImage.CONFIG.cqCode = !ChatImage.CONFIG.cqCode;
            button.setMessage((Component)this.getCq(ChatImage.CONFIG.cqCode));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 - 154, this.height / 4 + 72 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"cq.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getUri(ChatImage.CONFIG.checkImageUri), button -> {
            ChatImage.CONFIG.checkImageUri = !ChatImage.CONFIG.checkImageUri;
            button.setMessage((Component)this.getUri(ChatImage.CONFIG.checkImageUri));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 + 4, this.height / 4 + 72 - 16, 150, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getDragImage(ChatImage.CONFIG.dragImage), button -> {
            ChatImage.CONFIG.dragImage = !ChatImage.CONFIG.dragImage;
            button.setMessage((Component)this.getDragImage(ChatImage.CONFIG.dragImage));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 + 4, this.height / 4 + 96 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"image.drag.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getDrag(ChatImage.CONFIG.dragUseCicode), button -> {
            ChatImage.CONFIG.dragUseCicode = !ChatImage.CONFIG.dragUseCicode;
            button.setMessage((Component)this.getDrag(ChatImage.CONFIG.dragUseCicode));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 - 154, this.height / 4 + 96 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"drag.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)this.getExperimentalTextComponentCompatibility(ChatImage.CONFIG.experimentalTextComponentCompatibility), button -> {
            ChatImage.CONFIG.experimentalTextComponentCompatibility = !ChatImage.CONFIG.experimentalTextComponentCompatibility;
            button.setMessage((Component)this.getExperimentalTextComponentCompatibility(ChatImage.CONFIG.experimentalTextComponentCompatibility));
            ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
        }).bounds(this.width / 2 - 154, this.height / 4 + 120 - 16, 150, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"experimental.component.chatimage.tooltip"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.back"), button -> {
            if (this.minecraft != null) {
                this.minecraft.setScreen(this.parent);
            }
        }).bounds(this.width / 2 - 77, this.height / 4 + 144 - 16, 150, 20).build());
    }

    private MutableComponent getCq(boolean enable) {
        return ConfigScreen.getEnable("cq.chatimage.gui", enable);
    }

    private MutableComponent getNsfw(boolean enable) {
        return ConfigScreen.getEnable("nsfw.chatimage.gui", !enable);
    }

    private MutableComponent getDrag(boolean enable) {
        return ConfigScreen.getEnable("drag.chatimage.gui", enable);
    }

    private MutableComponent getDragImage(boolean enable) {
        return ConfigScreen.getEnable("image.drag.chatimage.gui", enable);
    }

    private MutableComponent getUri(boolean enable) {
        return ConfigScreen.getEnable("uri.chatimage.gui", enable);
    }

    private MutableComponent getExperimentalTextComponentCompatibility(boolean enable) {
        return ConfigScreen.getEnable("experimental.component.chatimage.gui", enable);
    }

    public static MutableComponent getEnable(String key, boolean enable) {
        return CommonComponents.optionNameValue((Component)Component.translatable((String)key), (Component)Component.translatable((String)((enable ? "open" : "close") + ".chatimage.common")));
    }
}

