/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import io.github.kituin.chatimage.network.ChatImagePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.neoforged.neoforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileChannelPacket {
    private final String message;
    private static final Logger LOGGER = LogManager.getLogger();

    public FileChannelPacket(FriendlyByteBuf buffer) {
        this.message = buffer.readUtf();
    }

    public FileChannelPacket(String message) {
        this.message = message;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.message);
    }

    public static boolean serverHandle(FileChannelPacket packet, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> ChatImagePacket.serverFileChannelReceived(ctx.getSender(), packet.message));
        return true;
    }
}

