/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.KeyBindings;
import io.github.kituin.chatimage.command.Help;
import io.github.kituin.chatimage.command.ReloadConfig;
import io.github.kituin.chatimage.command.SendChatImage;
import io.github.kituin.chatimage.gui.ConfigScreen;
import io.github.kituin.chatimage.integration.ChatImageClientAdapter;
import io.github.kituin.chatimage.integration.ChatImageLogger;
import io.github.kituin.chatimage.network.DownloadFileChannelHandler;
import io.github.kituin.chatimage.network.DownloadFileChannelPacket;
import io.github.kituin.chatimage.network.FileChannelHandler;
import io.github.kituin.chatimage.network.FileChannelPacket;
import io.github.kituin.chatimage.network.FileInfoChannelHandler;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.Commands;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.ConfigScreenHandler;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chatimage")
public class ChatImage {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "chatimage";
    public static ChatImageConfig CONFIG;

    public ChatImage(IEventBus modEventBus) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(ChatImage::register);
    }

    public static void register(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar(MOD_ID).optional();
        registrar.play(DownloadFileChannelPacket.DOWNLOAD_FILE_CHANNEL, DownloadFileChannelPacket::new, handler -> handler.client(DownloadFileChannelHandler.getInstance()::clientHandle));
        registrar.play(FileChannelPacket.FILE_CHANNEL, FileChannelPacket::new, handler -> handler.server(FileChannelHandler.getInstance()::serverHandle));
        registrar.play(FileInfoChannelPacket.FILE_INFO, FileInfoChannelPacket::new, handler -> handler.client(FileInfoChannelHandler.getInstance()::clientHandle).server(FileInfoChannelHandler.getInstance()::serverHandle));
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("[ChatImage]Server starting");
    }

    static {
        ChatImageCodeInstance.LOGGER = new ChatImageLogger();
    }

    @Mod.EventBusSubscriber(modid="chatimage", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onKeyBindRegister(RegisterKeyMappingsEvent event) {
            KeyBindings.init(event);
            LOGGER.info("KeyBindings Register");
        }

        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("[ChatImage]Client start");
            ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory((minecraft, screen) -> new ConfigScreen((Screen)screen)));
            NeoForge.EVENT_BUS.addListener(ClientModEvents::onKeyInput);
            NeoForge.EVENT_BUS.addListener(ClientModEvents::onClientStaring);
            NeoForge.EVENT_BUS.addListener(ClientModEvents::onClientCommand);
        }

        public static void onClientCommand(RegisterClientCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)ChatImage.MOD_ID).then(Commands.literal((String)"send").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes((Command)SendChatImage.instance))))).then(Commands.literal((String)"url").then(Commands.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes((Command)SendChatImage.instance)))).then(Commands.literal((String)"help").executes((Command)Help.instance))).then(Commands.literal((String)"reload").executes((Command)ReloadConfig.instance)));
        }

        public static void onKeyInput(InputEvent.Key event) {
            if (KeyBindings.gatherManaKeyMapping.consumeClick()) {
                Minecraft.getInstance().setScreen((Screen)new ConfigScreen(Minecraft.getInstance().screen));
            }
        }

        public static void onClientStaring(RegisterCommandsEvent event) {
        }

        static {
            ChatImageConfig.configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "chatimageconfig.json");
            CONFIG = ChatImageConfig.loadConfig();
            ChatImageCodeInstance.CLIENT_ADAPTER = new ChatImageClientAdapter();
        }
    }
}

