/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LimitSlider
extends SettingSliderWidget {
    protected final Component title;
    protected final LimitType limitType;

    public LimitSlider(int x, int y, int width, int height, Component title, int value, float max, LimitType limitType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 1.0f, max, tooltip);
        this.title = title;
        this.limitType = limitType;
        this.updateMessage();
    }

    protected void updateMessage() {
        switch (this.limitType) {
            case WIDTH: {
                this.setMessage((Component)CommonComponents.optionNameValue((Component)this.title, (Component)(ChatImage.CONFIG.limitWidth == 0 ? Component.translatable((String)"default.chatimage.gui") : Component.literal((String)String.valueOf(this.position)))));
                ChatImage.CONFIG.limitWidth = this.position;
                break;
            }
            case HEIGHT: {
                this.setMessage((Component)CommonComponents.optionNameValue((Component)this.title, (Component)(ChatImage.CONFIG.limitHeight == 0 ? Component.translatable((String)"default.chatimage.gui") : Component.literal((String)String.valueOf(this.position)))));
                ChatImage.CONFIG.limitHeight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
    }

    public static Component tooltip(LimitType limitType) {
        return switch (limitType) {
            default -> throw new IncompatibleClassChangeError();
            case LimitType.WIDTH -> Component.translatable((String)"width.limit.chatimage.tooltip");
            case LimitType.HEIGHT -> Component.translatable((String)"height.limit.chatimage.tooltip");
        };
    }

    public static enum LimitType {
        WIDTH,
        HEIGHT;

    }
}

