/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.command;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.client.ChatImageClient;
import io.github.kituin.chatimage.tool.SimpleUtil;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;

public class ChatImageCommand {
    public static int sendChatImage(CommandContext<FabricClientCommandSource> context) {
        String url = StringArgumentType.getString(context, (String)"url");
        ChatImageCode.Builder builder = ChatImageCodeInstance.createBuilder().setUrlForce(url);
        try {
            String name = StringArgumentType.getString(context, (String)"name");
            builder.setName(name);
        }
        catch (IllegalArgumentException e) {
            ChatImageCodeInstance.LOGGER.info("arg: `name` is omitted, use the default string");
        }
        ((FabricClientCommandSource)context.getSource()).getPlayer().method_44096(builder.build().toString(), null);
        return 1;
    }

    public static int help(CommandContext<FabricClientCommandSource> context) {
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)ChatImageCommand.getHelpText("/chatimage help", "", "help.chatimage.command").method_10852((class_2561)ChatImageCommand.getHelpText("/chatimage send ", "<name> <url>", "send.chatimage.command")).method_10852((class_2561)ChatImageCommand.getHelpText("/chatimage url ", "<url>", "url.chatimage.command")).method_10852((class_2561)ChatImageCommand.getHelpText("/chatimage reload ", "", "reload.chatimage.command")));
        return 1;
    }

    public static int reloadConfig(CommandContext<FabricClientCommandSource> context) {
        ChatImageClient.CONFIG = ChatImageConfig.loadConfig();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)SimpleUtil.createTranslatableComponent("success.reload.chatimage.command").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)));
        return 1;
    }

    private static class_5250 getHelpText(String help, String arg, String usage) {
        String all = help + arg;
        StringBuilder sb = new StringBuilder(all);
        if (all.length() <= 35) {
            for (int i = 0; i < 35 - all.length(); ++i) {
                sb.append(" ");
            }
        }
        class_5250 text = (class_5250)class_2561.method_30163((String)sb.toString());
        class_5250 info = class_2561.method_43471((String)usage);
        return text.method_10862(class_2583.field_24360.method_10977(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_11745, help))).method_10852((class_2561)info).method_10852(class_2561.method_30163((String)"\n"));
    }
}

