/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageBoolean;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatImageCodeTool {
    public static final List<String> passKeys = Lists.newArrayList((Object[])new String[]{"chat.type.text", "chat.type.emote", "chat.type.announcement", "commands.message.display.incoming", "commands.message.display.outgoing"});
    public static final Pattern cicodesPattern = Pattern.compile("(\\[\\[CICode,(.*?)\\]\\])");
    public static final Pattern cqPattern = Pattern.compile("\\[CQ:image,(.*?)\\]");
    public static final Pattern uriPattern = Pattern.compile("(https?:\\/\\/|file:\\/\\/\\/)?([\\w-]+(\\.[\\w-]+)*)(\\/[^\\s]*)?\\.(png!thumbnail|bmp|png|jpe?g|gif|ico)(\\?([a-zA-Z0-9_&=+-]+)(&[a-zA-Z0-9_&=+-]+)*)?");

    public static boolean checkKey(String key) {
        return passKeys.stream().anyMatch(key::equals);
    }

    public static void buildMsg(List<Object> texts, Consumer<String> appendString, Consumer<ChatImageCode> appendCode) {
        texts.forEach(obj -> {
            if (obj instanceof String) {
                appendString.accept((String)obj);
            } else if (obj instanceof ChatImageCode) {
                appendCode.accept((ChatImageCode)obj);
            }
        });
    }

    public static List<Object> sliceMsg(String checkedText, boolean isSelf, ChatImageBoolean allString, Consumer<Exception> logger) {
        Matcher m = cicodesPattern.matcher(checkedText);
        ArrayList res = Lists.newArrayList();
        int lastPosition = 0;
        allString.setValue(true);
        while (m.find()) {
            try {
                ChatImageCode image = ChatImageCodeInstance.createBuilder().fromCode(m.group()).setIsSelf(isSelf).build();
                if (m.start() != 0) {
                    res.add(checkedText.substring(lastPosition, m.start()));
                }
                lastPosition = m.end();
                res.add(image);
                allString.setValue(false);
            }
            catch (Exception e) {
                logger.accept(e);
            }
        }
        if (lastPosition != checkedText.length()) {
            res.add(checkedText.substring(lastPosition));
        }
        return res;
    }

    public static String checkCQCode(String checkedText) {
        Matcher cqm = cqPattern.matcher(checkedText);
        while (cqm.find()) {
            String[] cqArgs = cqm.group(1).split(",");
            String cq_Url = "";
            for (int i = 0; i < cqArgs.length; ++i) {
                String[] cqParams = cqArgs[i].split("=");
                if (!"url".equals(cqParams[0])) continue;
                cq_Url = cqParams[1];
                break;
            }
            if (cq_Url.isEmpty()) continue;
            checkedText = checkedText.substring(0, cqm.start()) + String.format("[[CICode,url=%s]]", cq_Url) + checkedText.substring(cqm.end());
        }
        return checkedText;
    }

    public static List<Object> checkImageUri(List<Object> texts, boolean isSelf, ChatImageBoolean allString) {
        int i = 0;
        while (i < texts.size()) {
            Object obj = texts.get(i);
            ++i;
            if (!(obj instanceof String)) continue;
            String checkedText = (String)obj;
            Matcher matcher = uriPattern.matcher(checkedText);
            int lastPosition = 0;
            boolean first = true;
            while (matcher.find()) {
                String url = matcher.group();
                ChatImageCode image = ChatImageCodeInstance.createBuilder().setUrl(url).setIsSelf(isSelf).build();
                if (matcher.start() != 0) {
                    if (first) {
                        texts.set(i - 1, checkedText.substring(lastPosition, matcher.start()));
                        first = false;
                    } else {
                        texts.add(i, checkedText.substring(lastPosition, matcher.start()));
                        ++i;
                    }
                }
                lastPosition = matcher.end();
                if (first) {
                    texts.set(i - 1, image);
                    first = false;
                } else {
                    texts.add(i, image);
                    ++i;
                }
                allString.setValue(false);
            }
            if (lastPosition == checkedText.length() || lastPosition == 0) continue;
            texts.add(i, checkedText.substring(lastPosition));
            ++i;
        }
        return texts;
    }
}

