/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.FileImageHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class NetworkHelper {
    public static int PacketLimit = 30000;
    public static Gson gson = new Gson();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> createFilePacket(String url, File file) {
        try (InputStream input = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            ArrayList stringList = Lists.newArrayList();
            byte[] byt = new byte[input.available()];
            int status = input.read(byt);
            int indexC = 1;
            ChatImageCodeInstance.LOGGER.debug("{} File Size: {}", url, byt.length);
            String base64 = Base64.getEncoder().encodeToString(byt);
            int total = base64.length();
            int packetLimit = PacketLimit - 50 - Integer.toString(total).length() * 2 - url.length();
            int count = total / packetLimit;
            int totalC = total % packetLimit == 0 ? count : count + 1;
            for (int index = 0; index <= total; index += packetLimit, ++indexC) {
                stringList.add(gson.toJson((Object)new ChatImageIndex(indexC, totalC, url, base64.substring(index, Math.min(index + packetLimit, total)))));
            }
            ArrayList arrayList = stringList;
            return arrayList;
        }
        catch (IOException e) {
            return Lists.newArrayList();
        }
    }

    public static void mergeFileBlocks(String url, Map<Integer, ChatImageIndex> blocks) {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i <= blocks.size(); ++i) {
            builder.append(blocks.get((Object)Integer.valueOf((int)i)).bytes);
        }
        FileImageHandler.loadFile(Base64.getDecoder().decode(builder.toString()), url);
    }
}

