/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.mixin;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageBoolean;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageCodeTool;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.ChatImageStyle;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={NewChatGui.class})
public class ChatComponentMixin
extends AbstractGui {
    @Shadow
    @Final
    private Minecraft field_146247_f;

    @ModifyVariable(at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/util/text/ITextComponent;IIZ)V"}, argsOnly=true)
    public ITextComponent addMessage(ITextComponent message) {
        if (ChatImage.CONFIG.experimentalTextComponentCompatibility) {
            StringBuilder sb = new StringBuilder();
            ITextComponent temp = this.chatImage$flattenTree(message, sb, false);
            ChatImageBoolean allString = new ChatImageBoolean(true);
            ChatImageCodeTool.sliceMsg(sb.toString(), true, allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
            if (!allString.isValue()) {
                message = temp;
            }
        }
        return this.chatimage$replaceMessage(message);
    }

    @Unique
    private ITextComponent chatImage$getContents(ITextComponent text) {
        return text;
    }

    @Unique
    private String chatImage$getText(ITextComponent text) {
        if (text instanceof StringTextComponent) {
            return ((StringTextComponent)text).func_150261_e();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    private ITextComponent chatimage$replaceCode(ITextComponent text) {
        IFormattableTextComponent iFormattableTextComponent;
        String checkedText;
        Style style;
        IFormattableTextComponent originText;
        boolean isSelf;
        IFormattableTextComponent player;
        String key;
        block13: {
            key = "";
            player = null;
            isSelf = false;
            originText = text.func_230532_e_();
            originText.func_150253_a().clear();
            style = text.func_150256_b();
            if (this.chatImage$getContents(text) instanceof StringTextComponent) {
                checkedText = this.chatImage$getText((ITextComponent)((StringTextComponent)this.chatImage$getContents(text)));
            } else {
                if (this.chatImage$getContents(text) instanceof TranslationTextComponent) {
                    TranslationTextComponent ttc = (TranslationTextComponent)this.chatImage$getContents(text);
                    key = ttc.func_150268_i();
                    Object[] args = ttc.func_150271_j();
                    if (ChatImageCodeTool.checkKey(key)) {
                        IFormattableTextComponent contents;
                        player = (IFormattableTextComponent)args[0];
                        isSelf = this.chatImage$getContents((ITextComponent)player).toString().equals(this.chatImage$getContents(this.field_146247_f.field_71439_g.func_200200_C_()).toString());
                        checkedText = args[1] instanceof String ? (String)args[1] : (this.chatImage$getContents((ITextComponent)(contents = (IFormattableTextComponent)args[1])) instanceof StringTextComponent ? this.chatImage$getText((ITextComponent)((StringTextComponent)this.chatImage$getContents((ITextComponent)contents))) : this.chatImage$getContents((ITextComponent)contents).toString());
                        break block13;
                    } else {
                        ArrayList argTexts = Lists.newArrayList();
                        Object[] objectArray = args;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            argTexts.add(this.chatimage$replaceMessage((ITextComponent)arg));
                            ++n2;
                        }
                        return SimpleUtil.createTranslatableComponent(key, argTexts.toArray()).func_230530_a_(style);
                    }
                }
                checkedText = this.chatImage$getContents(text).toString();
            }
        }
        if (ChatImage.CONFIG.cqCode) {
            checkedText = ChatImageCodeTool.checkCQCode(checkedText);
        }
        ChatImageBoolean allString = new ChatImageBoolean(true);
        List<Object> texts = ChatImageCodeTool.sliceMsg(checkedText, isSelf, allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
        if (ChatImage.CONFIG.checkImageUri) {
            ChatImageCodeTool.checkImageUri(texts, isSelf, allString);
        }
        if (allString.isValue()) {
            ChatImageCode action;
            ChatImageCode chatImageCode = action = style.func_150210_i() == null ? null : (ChatImageCode)style.func_150210_i().func_240662_a_(ChatImageStyle.SHOW_IMAGE);
            if (action != null) {
                action.retry();
            }
            try {
                ITextComponent showText = style.func_150210_i() == null ? null : (ITextComponent)style.func_150210_i().func_240662_a_(HoverEvent.Action.field_230550_a_);
                if (showText == null) return originText;
                if (!(this.chatImage$getContents(showText) instanceof StringTextComponent)) return originText;
                originText.func_230530_a_(style.func_240716_a_(new HoverEvent(ChatImageStyle.SHOW_IMAGE, (Object)ChatImageCodeInstance.createBuilder().fromCode(this.chatImage$getText((ITextComponent)((StringTextComponent)this.chatImage$getContents(showText)))).setIsSelf(isSelf).build())));
                return originText;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return originText;
        }
        IFormattableTextComponent res = SimpleUtil.createLiteralComponent("");
        ChatImageCodeTool.buildMsg(texts, obj -> res.func_230529_a_((ITextComponent)SimpleUtil.createLiteralComponent(obj).func_230530_a_(style)), obj -> res.func_230529_a_((ITextComponent)ChatImageStyle.messageFromCode(obj)));
        if (player == null) {
            iFormattableTextComponent = res;
            return iFormattableTextComponent;
        }
        iFormattableTextComponent = SimpleUtil.createTranslatableComponent(key, player, res).func_230530_a_(style);
        return iFormattableTextComponent;
    }

    @Unique
    private ITextComponent chatImage$flattenTree(Object originNode, StringBuilder mergedText, boolean openUrlStyle) {
        if (originNode instanceof String) {
            return SimpleUtil.createLiteralComponent((String)originNode);
        }
        ITextComponent node = (ITextComponent)originNode;
        Style tempStyle = node.func_150256_b();
        if (this.chatImage$getContents(node) instanceof TranslationTextComponent) {
            TranslationTextComponent ttc = (TranslationTextComponent)this.chatImage$getContents(node);
            Object[] args = ttc.func_150271_j();
            ArrayList argsNew = Lists.newArrayList();
            for (Object arg : args) {
                argsNew.add(this.chatImage$flattenTree(arg, mergedText, false));
            }
            return SimpleUtil.createTranslatableComponent(ttc.func_150268_i(), argsNew.toArray()).func_230530_a_(tempStyle);
        }
        String t = this.chatImage$getText(this.chatImage$getContents(node));
        mergedText.append(t);
        if (node.func_150253_a().isEmpty()) {
            return node;
        }
        IFormattableTextComponent res = null;
        ArrayList children = Lists.newArrayList();
        StringBuilder childSb = new StringBuilder(t);
        for (int i = 0; i < node.func_150253_a().size(); ++i) {
            boolean isLiteral;
            boolean check;
            ITextComponent child_;
            ITextComponent child = this.chatImage$flattenTree(child_, mergedText, (child_ = (ITextComponent)node.func_150253_a().get(i)).func_150256_b().func_150235_h() != null && child_.func_150256_b().func_150235_h().func_150669_a() == ClickEvent.Action.OPEN_URL);
            if (child == null) continue;
            Style childStyle = child.func_150256_b();
            if (tempStyle == null) {
                tempStyle = childStyle;
            }
            boolean bl = check = (isLiteral = this.chatImage$getContents(child) instanceof StringTextComponent) && (this.chatImage$isSame(childStyle, tempStyle) || openUrlStyle || childStyle.func_150235_h() != null && childStyle.func_150235_h().func_150669_a() == ClickEvent.Action.OPEN_URL);
            if (check) {
                childSb.append(this.chatImage$getText(this.chatImage$getContents(child)));
                if (child.func_150253_a().isEmpty() && i != node.func_150253_a().size() - 1) continue;
            }
            if (res == null) {
                res = SimpleUtil.createLiteralComponent(childSb.toString()).func_230530_a_(tempStyle);
            } else {
                children.add(SimpleUtil.createLiteralComponent(childSb.toString()).func_230530_a_(tempStyle));
            }
            if (!check) {
                children.add(child);
            }
            for (ITextComponent child__ : child.func_150253_a()) {
                children.add(child__);
            }
            childSb = new StringBuilder();
            tempStyle = null;
        }
        for (ITextComponent child : children) {
            res.func_230529_a_(child);
        }
        return res;
    }

    @Unique
    private boolean chatImage$isSame(Style childStyle, Style tempStyle) {
        if (childStyle == null || tempStyle == null) {
            return false;
        }
        return childStyle.func_150223_b() == tempStyle.func_150223_b() && Objects.equals(childStyle.func_240711_a_(), tempStyle.func_240711_a_()) && childStyle.func_150242_c() == tempStyle.func_150242_c() && childStyle.func_150233_f() == tempStyle.func_150233_f() && childStyle.func_150236_d() == tempStyle.func_150236_d() && childStyle.func_150234_e() == tempStyle.func_150234_e() && Objects.equals(childStyle.func_150235_h(), tempStyle.func_150235_h()) && Objects.equals(childStyle.func_150210_i(), tempStyle.func_150210_i()) && Objects.equals(childStyle.func_179986_j(), tempStyle.func_179986_j()) && Objects.equals(childStyle.func_240729_k_(), tempStyle.func_240729_k_());
    }

    @Unique
    private ITextComponent chatimage$replaceMessage(ITextComponent message) {
        try {
            IFormattableTextComponent res = (IFormattableTextComponent)this.chatimage$replaceCode(message);
            for (ITextComponent t : message.func_150253_a()) {
                res.func_230529_a_(this.chatimage$replaceMessage(t));
            }
            return res;
        }
        catch (Exception e) {
            ChatImageCodeInstance.LOGGER.warn("\u8bc6\u522b\u5931\u8d25:{}", e.getMessage());
            return message;
        }
    }
}

