/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.SimpleUtil;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LimitSlider
extends SettingSliderWidget {
    protected final LimitType limitType;
    protected final ITextComponent title;

    public LimitSlider(int x, int y, int width, int height, ITextComponent title, int value, float max, LimitType limitType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 1.0f, max, tooltip);
        this.title = title;
        this.limitType = limitType;
        this.func_230979_b_();
    }

    protected void func_230979_b_() {
        switch (this.limitType) {
            case WIDTH: {
                this.func_238482_a_((ITextComponent)SimpleUtil.composeGenericOptionComponent(this.title, (ITextComponent)(ChatImage.CONFIG.limitWidth == 0 ? SimpleUtil.createTranslatableComponent("default.chatimage.gui") : SimpleUtil.createLiteralComponent(String.valueOf(this.position)))));
                ChatImage.CONFIG.limitWidth = this.position;
                break;
            }
            case HEIGHT: {
                this.func_238482_a_((ITextComponent)SimpleUtil.composeGenericOptionComponent(this.title, (ITextComponent)(ChatImage.CONFIG.limitHeight == 0 ? SimpleUtil.createTranslatableComponent("default.chatimage.gui") : SimpleUtil.createLiteralComponent(String.valueOf(this.position)))));
                ChatImage.CONFIG.limitHeight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig(ChatImage.CONFIG);
    }

    public static ITextComponent tooltip(LimitType limitType) {
        switch (limitType) {
            case WIDTH: {
                return SimpleUtil.createTranslatableComponent("width.limit.chatimage.tooltip");
            }
            case HEIGHT: {
                return SimpleUtil.createTranslatableComponent("height.limit.chatimage.tooltip");
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum LimitType {
        WIDTH,
        HEIGHT;

    }
}

