/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.SimpleUtil;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaddingSlider
extends SettingSliderWidget {
    protected final PaddingType paddingType;
    protected final ITextComponent title;

    public PaddingSlider(int x, int y, int width, int height, ITextComponent title, int value, float max, PaddingType paddingType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 0.0f, max, tooltip);
        this.title = title;
        this.paddingType = paddingType;
        this.func_230979_b_();
    }

    protected void func_230979_b_() {
        this.func_238482_a_((ITextComponent)SimpleUtil.composeGenericOptionComponent(this.title, (ITextComponent)SimpleUtil.createLiteralComponent(String.valueOf(this.position))));
        switch (this.paddingType) {
            case TOP: {
                ChatImage.CONFIG.paddingTop = this.position;
                break;
            }
            case BOTTOM: {
                ChatImage.CONFIG.paddingBottom = this.position;
                break;
            }
            case LEFT: {
                ChatImage.CONFIG.paddingLeft = this.position;
                break;
            }
            case RIGHT: {
                ChatImage.CONFIG.paddingRight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig(ChatImage.CONFIG);
    }

    public static ITextComponent tooltip(PaddingType paddingType) {
        switch (paddingType) {
            case TOP: {
                return SimpleUtil.createTranslatableComponent("top.padding.chatimage.tooltip");
            }
            case BOTTOM: {
                return SimpleUtil.createTranslatableComponent("bottom.padding.chatimage.tooltip");
            }
            case LEFT: {
                return SimpleUtil.createTranslatableComponent("left.padding.chatimage.tooltip");
            }
            case RIGHT: {
                return SimpleUtil.createTranslatableComponent("right.padding.chatimage.tooltip");
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum PaddingType {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

