/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.NetworkHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerBlockCache {
    public HashMap<String, List<String>> userCache = new HashMap();
    public HashMap<String, Long> blockCacheTime = new HashMap();
    public HashMap<String, HashMap<Integer, String>> blockCache = new HashMap();
    public HashMap<String, Integer> fileCount = new HashMap();

    public HashMap<Integer, String> createBlock(ChatImageIndex title, String imgBytes) {
        HashMap<Integer, String> blocks;
        HashMap<Integer, String> hashMap = blocks = this.blockCache.containsKey(title.url) ? this.blockCache.get(title.url) : new HashMap<Integer, String>();
        if (blocks.isEmpty()) {
            this.blockCacheTime.put(title.url, System.currentTimeMillis());
        }
        blocks.put(title.index, imgBytes);
        this.blockCache.put(title.url, blocks);
        this.fileCount.put(title.url, title.total);
        return blocks;
    }

    public HashMap<Integer, String> getBlock(String url) {
        if (this.blockCache.containsKey(url) && this.fileCount.containsKey(url)) {
            HashMap<Integer, String> list = this.blockCache.get(url);
            Integer total = this.fileCount.get(url);
            if (total.intValue() == list.size()) {
                return list;
            }
        }
        return null;
    }

    public String getImage(String url) {
        HashMap<Integer, String> blocks = this.getBlock(url);
        StringBuilder base64Img = new StringBuilder();
        if (blocks != null) {
            for (int i = 1; i <= blocks.size(); ++i) {
                base64Img.append(((ChatImageIndex)NetworkHelper.gson.fromJson((String)blocks.get((Object)Integer.valueOf((int)i)), ChatImageIndex.class)).bytes);
            }
            return base64Img.toString();
        }
        return null;
    }

    public void tryAddUser(String url, String uuid) {
        ArrayList names = this.userCache.containsKey(url) ? this.userCache.get(url) : Lists.newArrayList();
        names.add(uuid);
        this.userCache.put(url, names);
    }

    public List<String> getUsers(String url) {
        if (this.userCache.containsKey(url)) {
            List<String> names = this.userCache.get(url);
            this.userCache.put(url, Lists.newArrayList());
            return names;
        }
        return null;
    }

    public void clear(long timestamp) {
        ArrayList keys = Lists.newArrayList();
        for (Map.Entry<String, Long> entry : this.blockCacheTime.entrySet()) {
            if (entry.getValue() >= timestamp) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            this.blockCache.remove(key);
            this.blockCacheTime.remove(key);
            this.fileCount.remove(key);
            this.userCache.remove(key);
        }
    }

    public void clear() {
        this.userCache.clear();
        this.blockCache.clear();
        this.blockCacheTime.clear();
        this.fileCount.clear();
    }
}

