/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.AbstractSlider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SettingSliderWidget
extends AbstractSlider {
    public static final OnTooltip NO_TOOLTIP = (p_93740_, p_93741_, p_93742_, p_93743_) -> {};
    protected final OnTooltip onTooltip;
    protected final double min;
    protected final double max;
    protected int position;
    protected boolean canTooltip = true;

    public SettingSliderWidget(int x, int y, int width, int height, int value, float min, float max) {
        this(x, y, width, height, value, min, max, NO_TOOLTIP);
    }

    public SettingSliderWidget(int x, int y, int width, int height, int value, float min, float max, OnTooltip tooltip) {
        super(x, y, width, height, (ITextComponent)SimpleUtil.createLiteralComponent(""), 0.0);
        this.min = min;
        this.max = max;
        this.field_230683_b_ = (MathHelper.func_76131_a((float)value, (float)min, (float)max) - min) / (max - min);
        this.func_230972_a_();
        this.onTooltip = tooltip;
    }

    public void func_230972_a_() {
        this.position = (int)MathHelper.func_219803_d((double)MathHelper.func_151237_a((double)this.field_230683_b_, (double)0.0, (double)1.0), (double)this.min, (double)this.max);
    }

    public void func_230443_a_(MatrixStack p_283427_, int p_281447_, int p_282852_) {
        if (this.canTooltip) {
            this.onTooltip.onTooltip(this, p_283427_, p_281447_, p_282852_);
        }
    }

    public void func_230441_a_(MatrixStack p_283427_, Minecraft pMinecraft, int pMouseX, int pMouseY) {
        super.func_230441_a_(p_283427_, pMinecraft, pMouseX, pMouseY);
        if (this.func_230449_g_()) {
            this.func_230443_a_(p_283427_, pMouseX, pMouseY);
        }
    }

    public void func_230982_a_(double p_93588_, double p_93589_) {
        super.func_230982_a_(p_93588_, p_93589_);
        this.canTooltip = false;
    }

    public void func_231000_a__(double p_93609_, double p_93610_) {
        this.canTooltip = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnTooltip {
        public void onTooltip(SettingSliderWidget var1, MatrixStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<ITextComponent> p_168842_) {
        }
    }
}

