/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.integration;

import com.mojang.blaze3d.platform.NativeImage;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.IClientAdapter;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.network.ChatImagePacket;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ChatImageClientAdapter
implements IClientAdapter {
    public int getTimeOut() {
        return ChatImage.CONFIG.timeout;
    }

    public ChatImageFrame.TextureReader<ResourceLocation> loadTexture(InputStream image) throws IOException {
        NativeImage nativeImage = NativeImage.read((InputStream)image);
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"chatimage", (String)"chatimage");
        Minecraft.getInstance().getTextureManager().register(id, (AbstractTexture)new DynamicTexture(nativeImage));
        return new ChatImageFrame.TextureReader((Object)id, nativeImage.getWidth(), nativeImage.getHeight());
    }

    public void sendToServer(String url, File file, boolean isToServer) {
        if (isToServer) {
            List bufs = NetworkHelper.createFilePacket((String)url, (File)file);
            ChatImagePacket.sendFilePackets(bufs);
        } else {
            ChatImagePacket.loadFromServer(url);
        }
    }

    public void checkCachePath() {
        File folder = new File(ChatImage.CONFIG.cachePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public int getMaxFileSize() {
        return ChatImage.CONFIG.MaxFileSize;
    }

    public Component getProcessMessage(int i) {
        return Component.translatable((String)"process.chatimage.message", (Object[])new Object[]{i});
    }
}

