/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaddingSlider
extends SettingSliderWidget {
    protected final Component title;
    protected final PaddingType paddingType;

    public PaddingSlider(int x, int y, int width, int height, Component title, int value, float max, PaddingType paddingType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 0.0f, max, tooltip);
        this.title = title;
        this.paddingType = paddingType;
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.title, (Component)Component.literal((String)String.valueOf(this.position))));
        switch (this.paddingType.ordinal()) {
            case 2: {
                ChatImage.CONFIG.paddingTop = this.position;
                break;
            }
            case 3: {
                ChatImage.CONFIG.paddingBottom = this.position;
                break;
            }
            case 0: {
                ChatImage.CONFIG.paddingLeft = this.position;
                break;
            }
            case 1: {
                ChatImage.CONFIG.paddingRight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
    }

    public static Component tooltip(PaddingType paddingType) {
        return switch (paddingType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 2 -> Component.translatable((String)"top.padding.chatimage.tooltip");
            case 3 -> Component.translatable((String)"bottom.padding.chatimage.tooltip");
            case 0 -> Component.translatable((String)"left.padding.chatimage.tooltip");
            case 1 -> Component.translatable((String)"right.padding.chatimage.tooltip");
        };
    }

    public static enum PaddingType {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

