/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.KeyBindings;
import io.github.kituin.chatimage.command.Help;
import io.github.kituin.chatimage.command.ReloadConfig;
import io.github.kituin.chatimage.command.SendChatImage;
import io.github.kituin.chatimage.gui.ConfigScreen;
import io.github.kituin.chatimage.integration.ChatImageClientAdapter;
import io.github.kituin.chatimage.integration.ChatImageLogger;
import io.github.kituin.chatimage.network.DownloadFileChannel;
import io.github.kituin.chatimage.network.FileBackChannel;
import io.github.kituin.chatimage.network.FileChannel;
import io.github.kituin.chatimage.network.FileInfoChannel;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.Commands;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigGuiHandler;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="chatimage")
public class ChatImage {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "chatimage";
    public static ChatImageConfig CONFIG;

    public ChatImage() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        MinecraftForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(ChatImage::init);
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(FileChannel::register);
        event.enqueueWork(FileInfoChannel::registerMessage);
        event.enqueueWork(FileBackChannel::register);
        event.enqueueWork(DownloadFileChannel::register);
        LOGGER.info("[ChatImage]Channel Register");
    }

    static {
        ChatImageCodeInstance.LOGGER = new ChatImageLogger();
    }

    @Mod.EventBusSubscriber(modid="chatimage", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            LOGGER.info("[ChatImage]Client start");
            KeyBindings.init();
            LOGGER.info("KeyBindings Register");
            ModLoadingContext.get().registerExtensionPoint(ConfigGuiHandler.ConfigGuiFactory.class, () -> new ConfigGuiHandler.ConfigGuiFactory((minecraft, screen) -> new ConfigScreen((Screen)screen)));
            MinecraftForge.EVENT_BUS.addListener(ClientModEvents::onClientCommand);
            MinecraftForge.EVENT_BUS.addListener(ClientModEvents::onKeyInput);
            MinecraftForge.EVENT_BUS.addListener(ClientModEvents::onClientStaring);
        }

        public static void onClientCommand(RegisterClientCommandsEvent event) {
            CommandDispatcher dispatcher = event.getDispatcher();
            LiteralCommandNode cmd = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)ChatImage.MOD_ID).then(Commands.m_82127_((String)"send").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes((Command)SendChatImage.instance))))).then(Commands.m_82127_((String)"url").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes((Command)SendChatImage.instance)))).then(Commands.m_82127_((String)"help").executes((Command)Help.instance))).then(Commands.m_82127_((String)"reload").executes((Command)ReloadConfig.instance)));
        }

        public static void onKeyInput(InputEvent.KeyInputEvent event) {
            if (KeyBindings.gatherManaKeyMapping.m_90859_()) {
                Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen(Minecraft.m_91087_().f_91080_));
            }
        }

        public static void onClientStaring(RegisterCommandsEvent event) {
        }

        static {
            ChatImageConfig.configFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "chatimageconfig.json");
            CONFIG = ChatImageConfig.loadConfig();
            ChatImageCodeInstance.CLIENT_ADAPTER = new ChatImageClientAdapter();
        }
    }
}

