/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class SettingSliderWidget
extends AbstractSliderButton {
    public static final OnTooltip NO_TOOLTIP = (p_93740_, p_93741_, p_93742_, p_93743_) -> {};
    protected final OnTooltip onTooltip;
    protected final double min;
    protected final double max;
    protected int position;
    protected boolean canTooltip = true;

    public SettingSliderWidget(int x, int y, int width, int height, int value, float min, float max) {
        this(x, y, width, height, value, min, max, NO_TOOLTIP);
    }

    public SettingSliderWidget(int x, int y, int width, int height, int value, float min, float max, OnTooltip tooltip) {
        super(x, y, width, height, (Component)SimpleUtil.createLiteralComponent(""), 0.0);
        this.min = min;
        this.max = max;
        this.f_93577_ = (Mth.m_14036_((float)value, (float)min, (float)max) - min) / (max - min);
        this.m_5697_();
        this.onTooltip = tooltip;
    }

    public void m_5697_() {
        this.position = (int)Mth.m_14139_((double)Mth.m_14008_((double)this.f_93577_, (double)0.0, (double)1.0), (double)this.min, (double)this.max);
    }

    public void m_7428_(PoseStack p_283427_, int p_281447_, int p_282852_) {
        if (this.canTooltip) {
            this.onTooltip.onTooltip(this, p_283427_, p_281447_, p_282852_);
        }
    }

    public void m_7906_(PoseStack p_283427_, Minecraft pMinecraft, int pMouseX, int pMouseY) {
        super.m_7906_(p_283427_, pMinecraft, pMouseX, pMouseY);
        if (this.m_198029_()) {
            this.m_7428_(p_283427_, pMouseX, pMouseY);
        }
    }

    public void m_5716_(double p_93588_, double p_93589_) {
        super.m_5716_(p_93588_, p_93589_);
        this.canTooltip = false;
    }

    public void m_7691_(double p_93609_, double p_93610_) {
        this.canTooltip = true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface OnTooltip {
        public void onTooltip(SettingSliderWidget var1, PoseStack var2, int var3, int var4);

        default public void narrateTooltip(Consumer<Component> p_168842_) {
        }
    }
}

