/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.mixin;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageBoolean;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageCodeTool;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.ChatImageStyle;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft f_93758_;

    @ModifyVariable(at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, argsOnly=true)
    public Component addMessage(Component message) {
        if (ChatImage.CONFIG.experimentalTextComponentCompatibility) {
            StringBuilder sb = new StringBuilder();
            Component temp = this.chatImage$flattenTree(message, sb, false);
            ChatImageBoolean allString = new ChatImageBoolean(true);
            ChatImageCodeTool.sliceMsg((String)sb.toString(), (boolean)true, (ChatImageBoolean)allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
            if (!allString.isValue()) {
                message = temp;
            }
        }
        return this.chatimage$replaceMessage(message);
    }

    @Unique
    private Component chatImage$getContents(Component text) {
        return text;
    }

    @Unique
    private String chatImage$getText(Component text) {
        if (text instanceof TextComponent) {
            return ((TextComponent)text).m_6111_();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    private Component chatimage$replaceCode(Component text) {
        MutableComponent mutableComponent;
        String checkedText;
        Style style;
        MutableComponent originText;
        boolean isSelf;
        MutableComponent player;
        String key;
        block13: {
            key = "";
            player = null;
            isSelf = false;
            originText = text.m_6881_();
            originText.m_7360_().clear();
            style = text.m_7383_();
            if (this.chatImage$getContents(text) instanceof TextComponent) {
                checkedText = this.chatImage$getText((Component)((TextComponent)this.chatImage$getContents(text)));
            } else {
                if (this.chatImage$getContents(text) instanceof TranslatableComponent) {
                    TranslatableComponent ttc = (TranslatableComponent)this.chatImage$getContents(text);
                    key = ttc.m_131328_();
                    Object[] args = ttc.m_131329_();
                    if (ChatImageCodeTool.checkKey((String)key)) {
                        MutableComponent contents;
                        player = (MutableComponent)args[0];
                        isSelf = this.chatImage$getContents((Component)player).toString().equals(this.chatImage$getContents(this.f_93758_.f_91074_.m_7755_()).toString());
                        checkedText = args[1] instanceof String ? (String)args[1] : (this.chatImage$getContents((Component)(contents = (MutableComponent)args[1])) instanceof TextComponent ? this.chatImage$getText((Component)((TextComponent)this.chatImage$getContents((Component)contents))) : this.chatImage$getContents((Component)contents).toString());
                        break block13;
                    } else {
                        ArrayList argTexts = Lists.newArrayList();
                        Object[] objectArray = args;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            argTexts.add(this.chatimage$replaceMessage((Component)arg));
                            ++n2;
                        }
                        return SimpleUtil.createTranslatableComponent(key, argTexts.toArray()).m_6270_(style);
                    }
                }
                checkedText = this.chatImage$getContents(text).toString();
            }
        }
        if (ChatImage.CONFIG.cqCode) {
            checkedText = ChatImageCodeTool.checkCQCode((String)checkedText);
        }
        ChatImageBoolean allString = new ChatImageBoolean(true);
        List texts = ChatImageCodeTool.sliceMsg((String)checkedText, (boolean)isSelf, (ChatImageBoolean)allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
        if (ChatImage.CONFIG.checkImageUri) {
            ChatImageCodeTool.checkImageUri((List)texts, (boolean)isSelf, (ChatImageBoolean)allString);
        }
        if (allString.isValue()) {
            ChatImageCode action;
            ChatImageCode chatImageCode = action = style.m_131186_() == null ? null : (ChatImageCode)style.m_131186_().m_130823_(ChatImageStyle.SHOW_IMAGE);
            if (action != null) {
                action.retry();
            }
            try {
                Component showText = style.m_131186_() == null ? null : (Component)style.m_131186_().m_130823_(HoverEvent.Action.f_130831_);
                if (showText == null) return originText;
                if (!(this.chatImage$getContents(showText) instanceof TextComponent)) return originText;
                originText.m_6270_(style.m_131144_(new HoverEvent(ChatImageStyle.SHOW_IMAGE, (Object)ChatImageCodeInstance.createBuilder().fromCode(this.chatImage$getText((Component)((TextComponent)this.chatImage$getContents(showText)))).setIsSelf(isSelf).build())));
                return originText;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return originText;
        }
        MutableComponent res = SimpleUtil.createLiteralComponent("");
        ChatImageCodeTool.buildMsg((List)texts, obj -> res.m_7220_((Component)SimpleUtil.createLiteralComponent(obj).m_6270_(style)), obj -> res.m_7220_((Component)ChatImageStyle.messageFromCode(obj)));
        if (player == null) {
            mutableComponent = res;
            return mutableComponent;
        }
        mutableComponent = SimpleUtil.createTranslatableComponent(key, player, res).m_6270_(style);
        return mutableComponent;
    }

    @Unique
    private Component chatImage$flattenTree(Component node, StringBuilder mergedText, boolean openUrlStyle) {
        Style tempStyle = node.m_7383_();
        if (this.chatImage$getContents(node) instanceof TranslatableComponent) {
            TranslatableComponent ttc = (TranslatableComponent)this.chatImage$getContents(node);
            Object[] args = ttc.m_131329_();
            ArrayList argsNew = Lists.newArrayList();
            for (Object arg : args) {
                argsNew.add(this.chatImage$flattenTree((Component)arg, mergedText, false));
            }
            return SimpleUtil.createTranslatableComponent(ttc.m_131328_(), argsNew.toArray()).m_6270_(tempStyle);
        }
        String t = this.chatImage$getText(this.chatImage$getContents(node));
        mergedText.append(t);
        if (node.m_7360_().isEmpty()) {
            return node;
        }
        MutableComponent res = null;
        ArrayList children = Lists.newArrayList();
        StringBuilder childSb = new StringBuilder(t);
        for (int i = 0; i < node.m_7360_().size(); ++i) {
            boolean isLiteral;
            boolean check;
            Component child_;
            Component child = this.chatImage$flattenTree(child_, mergedText, (child_ = (Component)node.m_7360_().get(i)).m_7383_().m_131182_() != null && child_.m_7383_().m_131182_().m_130622_() == ClickEvent.Action.OPEN_URL);
            if (child == null) continue;
            Style childStyle = child.m_7383_();
            if (tempStyle == null) {
                tempStyle = childStyle;
            }
            boolean bl = check = (isLiteral = this.chatImage$getContents(child) instanceof TextComponent) && (this.chatImage$isSame(childStyle, tempStyle) || openUrlStyle || childStyle.m_131182_() != null && childStyle.m_131182_().m_130622_() == ClickEvent.Action.OPEN_URL);
            if (check) {
                childSb.append(this.chatImage$getText(this.chatImage$getContents(child)));
                if (child.m_7360_().isEmpty() && i != node.m_7360_().size() - 1) continue;
            }
            if (res == null) {
                res = SimpleUtil.createLiteralComponent(childSb.toString()).m_6270_(tempStyle);
            } else {
                children.add(SimpleUtil.createLiteralComponent(childSb.toString()).m_6270_(tempStyle));
            }
            if (!check) {
                children.add(child);
            }
            for (Component child__ : child.m_7360_()) {
                children.add(child__);
            }
            childSb = new StringBuilder();
            tempStyle = null;
        }
        for (Component child : children) {
            res.m_7220_(child);
        }
        return res;
    }

    @Unique
    private boolean chatImage$isSame(Style childStyle, Style tempStyle) {
        if (childStyle == null || tempStyle == null) {
            return false;
        }
        return childStyle.m_131154_() == tempStyle.m_131154_() && Objects.equals(childStyle.m_131135_(), tempStyle.m_131135_()) && childStyle.m_131161_() == tempStyle.m_131161_() && childStyle.m_131176_() == tempStyle.m_131176_() && childStyle.m_131168_() == tempStyle.m_131168_() && childStyle.m_131171_() == tempStyle.m_131171_() && Objects.equals(childStyle.m_131182_(), tempStyle.m_131182_()) && Objects.equals(childStyle.m_131186_(), tempStyle.m_131186_()) && Objects.equals(childStyle.m_131189_(), tempStyle.m_131189_()) && Objects.equals(childStyle.m_131192_(), tempStyle.m_131192_());
    }

    @Unique
    private Component chatimage$replaceMessage(Component message) {
        try {
            MutableComponent res = (MutableComponent)this.chatimage$replaceCode(message);
            for (Component t : message.m_7360_()) {
                res.m_7220_(this.chatimage$replaceMessage(t));
            }
            return res;
        }
        catch (Exception e) {
            ChatImageCodeInstance.LOGGER.warn("\u8bc6\u522b\u5931\u8d25:{}", new Object[]{e.getMessage()});
            return message;
        }
    }
}

