/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.tool;

import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import io.github.kituin.chatimage.tool.SimpleUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ChatImageStyle {
    public static final HoverEvent.Action<ChatImageCode> SHOW_IMAGE = new HoverEvent.Action("show_chatimage", true, ChatImageCode::fromJson, ChatImageCode::toJson, ChatImageStyle::fromJson);

    public static ChatImageCode fromJson(Component text) {
        try {
            return ChatImageCodeInstance.createBuilder().fromCode(text.toString()).build();
        }
        catch (InvalidChatImageCodeException e) {
            return ChatImageCodeInstance.createBuilder().build();
        }
    }

    public static Style getStyleFromCode(ChatImageCode code) {
        return ChatImageStyle.getStyleFromCode(code, ChatFormatting.GREEN);
    }

    public static Style getStyleFromCode(ChatImageCode code, ChatFormatting color) {
        Style style = Style.f_131099_.m_131144_(new HoverEvent(SHOW_IMAGE, (Object)code));
        return style.m_131140_(color);
    }

    public static MutableComponent messageFromCode(ChatImageCode code) {
        MutableComponent t = (MutableComponent)code.messageFromCode(SimpleUtil::createLiteralComponent, SimpleUtil::createTranslatableComponent, MutableComponent::m_7220_);
        Style style = ChatImageStyle.getStyleFromCode(code);
        return t.m_6270_(style);
    }
}

