/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.SimpleUtil;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaddingSlider
extends SettingSliderWidget {
    protected final PaddingType paddingType;
    protected final Component title;

    public PaddingSlider(int x, int y, int width, int height, Component title, int value, float max, PaddingType paddingType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 0.0f, max, tooltip);
        this.title = title;
        this.paddingType = paddingType;
        this.m_5695_();
    }

    protected void m_5695_() {
        this.m_93666_((Component)SimpleUtil.composeGenericOptionComponent(this.title, (Component)SimpleUtil.createLiteralComponent(String.valueOf(this.position))));
        switch (this.paddingType.ordinal()) {
            case 2: {
                ChatImage.CONFIG.paddingTop = this.position;
                break;
            }
            case 3: {
                ChatImage.CONFIG.paddingBottom = this.position;
                break;
            }
            case 0: {
                ChatImage.CONFIG.paddingLeft = this.position;
                break;
            }
            case 1: {
                ChatImage.CONFIG.paddingRight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
    }

    public static Component tooltip(PaddingType paddingType) {
        switch (paddingType.ordinal()) {
            case 2: {
                return SimpleUtil.createTranslatableComponent("top.padding.chatimage.tooltip");
            }
            case 3: {
                return SimpleUtil.createTranslatableComponent("bottom.padding.chatimage.tooltip");
            }
            case 0: {
                return SimpleUtil.createTranslatableComponent("left.padding.chatimage.tooltip");
            }
            case 1: {
                return SimpleUtil.createTranslatableComponent("right.padding.chatimage.tooltip");
            }
        }
        throw new IllegalArgumentException();
    }

    public static enum PaddingType {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

