/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.widget;

import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.widget.SettingSliderWidget;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PaddingSlider
extends SettingSliderWidget {
    protected final Component title;
    protected final PaddingType paddingType;

    public PaddingSlider(int x, int y, int width, int height, Component title, int value, float max, PaddingType paddingType, SettingSliderWidget.OnTooltip tooltip) {
        super(x, y, width, height, value, 0.0f, max, tooltip);
        this.title = title;
        this.paddingType = paddingType;
        this.updateMessage();
    }

    protected void updateMessage() {
        this.setMessage((Component)CommonComponents.optionNameValue((Component)this.title, (Component)Component.literal((String)String.valueOf(this.position))));
        switch (this.paddingType) {
            case TOP: {
                ChatImage.CONFIG.paddingTop = this.position;
                break;
            }
            case BOTTOM: {
                ChatImage.CONFIG.paddingBottom = this.position;
                break;
            }
            case LEFT: {
                ChatImage.CONFIG.paddingLeft = this.position;
                break;
            }
            case RIGHT: {
                ChatImage.CONFIG.paddingRight = this.position;
                break;
            }
            default: {
                return;
            }
        }
        ChatImageConfig.saveConfig((ChatImageConfig)ChatImage.CONFIG);
    }

    public static Component tooltip(PaddingType paddingType) {
        return switch (paddingType) {
            default -> throw new IncompatibleClassChangeError();
            case PaddingType.TOP -> Component.translatable((String)"top.padding.chatimage.tooltip");
            case PaddingType.BOTTOM -> Component.translatable((String)"bottom.padding.chatimage.tooltip");
            case PaddingType.LEFT -> Component.translatable((String)"left.padding.chatimage.tooltip");
            case PaddingType.RIGHT -> Component.translatable((String)"right.padding.chatimage.tooltip");
        };
    }

    public static enum PaddingType {
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

