/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.FileImageHandler;
import io.github.kituin.ChatImageCode.HttpImageHandler;
import io.github.kituin.ChatImageCode.enums.UrlMethod;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatImageCode {
    public static final Pattern pattern = Pattern.compile("\\[\\[CICode,(.+)\\]\\]");
    private String url = "";
    private boolean nsfw = false;
    public static final String DEFAULT_NAME = "codename.chatimage.default";
    public static final String DEFAULT_PREFIX = "[";
    public static final String DEFAULT_SUFFIX = "]";
    private String name = "codename.chatimage.default";
    private String prefix = "[";
    private String suffix = "]";
    private boolean isSelf = false;
    private final long timestamp;
    private String httpUrl;
    private UrlMethod urlMethod = UrlMethod.UNKNOWN;
    private String fileUrl;

    private ChatImageCode() {
        this.timestamp = System.currentTimeMillis();
    }

    public ChatImageFrame getFrame() {
        if (this.url.isEmpty()) {
            return new ChatImageFrame(ChatImageFrame.FrameError.ILLEGAL_CICODE_ERROR);
        }
        ChatImageFrame frame = ClientStorage.getImage(this.getUrl());
        if (frame == null) {
            return new ChatImageFrame(ChatImageFrame.FrameError.LOADING);
        }
        return frame;
    }

    private void match(String originalCode) throws InvalidChatImageCodeException {
        Matcher matcher = pattern.matcher(originalCode);
        if (!matcher.find()) {
            throw new InvalidChatImageCodeException(originalCode + "<-can not find any String to ChatImageCode, Please Recheck");
        }
        this.slice(matcher.group(1));
    }

    private void slice(String rawCode) throws InvalidChatImageCodeException {
        String[] raws;
        for (String raw : raws = rawCode.split(",")) {
            String[] temps = raw.split("=", 2);
            if (temps.length == 2) {
                switch (temps[0].trim()) {
                    case "url": {
                        this.checkUrl(temps[1].trim());
                        break;
                    }
                    case "nsfw": {
                        this.nsfw = Boolean.parseBoolean(temps[1].trim());
                        break;
                    }
                    case "name": {
                        this.name = temps[1].trim();
                        break;
                    }
                    case "pre": {
                        this.prefix = temps[1];
                        break;
                    }
                    case "suf": {
                        this.suffix = temps[1];
                    }
                }
                continue;
            }
            throw new InvalidChatImageCodeException(raw + "<-can not match the value of ChatImageCode, Please Recheck");
        }
        if (this.url.isEmpty()) {
            throw new InvalidChatImageCodeException("not match url in ChatImageCode, Please Recheck");
        }
    }

    public String getUrl() {
        switch (this.urlMethod) {
            case HTTP: {
                return this.httpUrl;
            }
            case FILE: {
                return this.fileUrl;
            }
        }
        return this.url;
    }

    public void checkUrl(String url) {
        URI uri;
        if (url == null || url.isEmpty()) {
            ClientStorage.AddImageError(url, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        this.url = url.replace("\\", "/").replace(" ", "%20");
        try {
            uri = new URI(this.url);
        }
        catch (URISyntaxException e) {
            ClientStorage.AddImageError(this.url, ChatImageFrame.FrameError.INVALID_URL);
            return;
        }
        if (ChatImageCodeInstance.CLIENT_ADAPTER == null) {
            return;
        }
        ChatImageCodeInstance.CLIENT_ADAPTER.checkCachePath();
        if (Objects.equals(uri.getScheme(), "https") || Objects.equals(uri.getScheme(), "http")) {
            boolean f;
            this.urlMethod = UrlMethod.HTTP;
            this.httpUrl = uri.toString();
            if (!ClientStorage.ContainImageAndCheck(this.httpUrl) && !(f = HttpImageHandler.request(this.httpUrl))) {
                ClientStorage.AddImageError(this.httpUrl, ChatImageFrame.FrameError.INVALID_URL);
            }
        } else if (Objects.equals(uri.getScheme(), "file")) {
            this.urlMethod = UrlMethod.FILE;
            this.fileUrl = Paths.get(uri).toString().replace("file:///", "");
            File file = new File(this.fileUrl);
            if (!ClientStorage.ContainImageAndCheck(this.fileUrl)) {
                boolean fileExist = file.exists();
                if (fileExist) {
                    FileImageHandler.loadFile(this.fileUrl);
                }
                ChatImageCodeInstance.CLIENT_ADAPTER.sendToServer(this.fileUrl, file, fileExist);
            }
        } else {
            ClientStorage.AddImageError(this.url, ChatImageFrame.FrameError.INVALID_URL);
        }
    }

    public void retry() {
        this.checkUrl(this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[[CICode");
        if (this.nsfw) {
            sb.append(",nsfw=true");
        }
        if (this.name != null && !this.name.equals(DEFAULT_NAME)) {
            sb.append(",name=").append(this.name);
        }
        if (!Objects.equals(this.prefix, DEFAULT_PREFIX)) {
            sb.append(",nsfw=").append(this.suffix);
        }
        if (!Objects.equals(this.suffix, DEFAULT_SUFFIX)) {
            sb.append(",suffix=").append(this.suffix);
        }
        sb.append(",url=").append(this.url);
        return sb.append("]]").toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isNsfw() {
        return this.nsfw;
    }

    public boolean isSendFromSelf() {
        return this.isSelf;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.timestamp + 1000L * (long)ChatImageCodeInstance.CLIENT_ADAPTER.getTimeOut();
    }

    public <Mutable> Mutable messageFromCode(Function<String, Mutable> newText, Function<String, Mutable> newTranslatableText, BiFunction<Mutable, Mutable, Mutable> appendText) {
        Mutable t = newText.apply(this.prefix);
        if (DEFAULT_NAME.equals(this.name)) {
            appendText.apply(t, newTranslatableText.apply(this.name));
        } else {
            appendText.apply(t, newText.apply(this.name));
        }
        appendText.apply(t, newText.apply(this.suffix));
        return t;
    }

    public static ChatImageCode fromJson(JsonElement json) {
        JsonObject jsonObject = json.getAsJsonObject();
        Builder builder = ChatImageCodeInstance.createBuilder();
        if (jsonObject.has("url")) {
            builder.setUrlForce(jsonObject.get("url").getAsString());
        }
        if (jsonObject.has("name")) {
            builder.setName(jsonObject.get("name").getAsString());
        }
        if (jsonObject.has("prefix")) {
            builder.setPrefix(jsonObject.get("prefix").getAsString());
        }
        if (jsonObject.has("suffix")) {
            builder.setSuffix(jsonObject.get("suffix").getAsString());
        }
        if (jsonObject.has("nsfw")) {
            builder.setNsfw(jsonObject.get("nsfw").getAsBoolean());
        }
        return builder.build();
    }

    public static JsonElement toJson(ChatImageCode code) {
        JsonObject jsonObject = new JsonObject();
        if (!code.getName().equals(DEFAULT_NAME)) {
            jsonObject.addProperty("name", code.getName());
        }
        if (!code.getPrefix().equals(DEFAULT_PREFIX)) {
            jsonObject.addProperty("prefix", code.getPrefix());
        }
        if (!code.getSuffix().equals(DEFAULT_SUFFIX)) {
            jsonObject.addProperty("suffix", code.getSuffix());
        }
        jsonObject.addProperty("url", code.getUrl());
        if (code.isNsfw()) {
            jsonObject.addProperty("nsfw", Boolean.valueOf(code.isNsfw()));
        }
        return jsonObject;
    }

    public static class Builder {
        private final ChatImageCode code = new ChatImageCode();

        public ChatImageCode build() {
            return this.code;
        }

        public Builder fromCode(String ciCode) throws InvalidChatImageCodeException {
            this.code.match(ciCode);
            return this;
        }

        public Builder setName(String name) {
            if (name != null) {
                this.code.name = name;
            }
            return this;
        }

        public Builder setUrl(String url) {
            this.code.checkUrl(url);
            return this;
        }

        public Builder setUrlForce(String url) {
            this.code.url = url;
            return this;
        }

        public Builder setNsfw(boolean nsfw) {
            this.code.nsfw = nsfw;
            return this;
        }

        public Builder setIsSelf(boolean isSelf) {
            this.code.isSelf = isSelf;
            return this;
        }

        public Builder setPrefix(String prefix) {
            if (prefix != null) {
                this.code.prefix = prefix;
            }
            return this;
        }

        public Builder setSuffix(String suffix) {
            if (suffix != null) {
                this.code.suffix = suffix;
            }
            return this;
        }
    }
}

