/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.chatimage.network.ChatImagePacket;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInfoChannelHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FileInfoChannelHandler INSTANCE = new FileInfoChannelHandler();

    public static FileInfoChannelHandler getInstance() {
        return INSTANCE;
    }

    public void serverHandle(FileInfoChannelPacket packet, PlayPayloadContext ctx) {
        ctx.player().ifPresent(player -> ChatImagePacket.serverFileInfoChannelReceived((ServerPlayer)player, packet.message()));
    }

    public void clientHandle(FileInfoChannelPacket packet, PlayPayloadContext ctx) {
        String data = packet.message();
        String url = data.substring(6);
        LOGGER.info(url);
        if (data.startsWith("null")) {
            LOGGER.info("[GetFileChannel-NULL]" + url);
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        } else if (data.startsWith("true")) {
            LOGGER.info("[GetFileChannel-Retry]" + url);
            ChatImagePacket.loadFromServer(url);
        }
    }
}

