/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import com.google.gson.Gson;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.ChatImageCode.ServerStorage;
import io.github.kituin.chatimage.network.DownloadFileChannel;
import io.github.kituin.chatimage.network.DownloadFileChannelPacket;
import io.github.kituin.chatimage.network.FileBackChannel;
import io.github.kituin.chatimage.network.FileChannel;
import io.github.kituin.chatimage.network.FileChannelPacket;
import io.github.kituin.chatimage.network.FileInfoChannel;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;

public class ChatImagePacket {
    public static Gson gson = new Gson();

    public static void sendFilePackets(List<String> bufs) {
        for (String buf : bufs) {
            FileChannel.sendToServer(new FileChannelPacket(buf));
        }
    }

    public static void loadFromServer(String url) {
        if (Minecraft.m_91087_().f_91074_ != null) {
            FileInfoChannel.sendToServer(new FileInfoChannelPacket(url));
            ChatImageCodeInstance.LOGGER.info("[try get from server]" + url);
        } else {
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        }
    }

    public static void serverFileChannelReceived(ServerPlayer player, String res) {
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ServerStorage.SERVER_BLOCK_CACHE.createBlock(title, res);
        ChatImageCodeInstance.LOGGER.info("[FileChannel->Server:" + title.index + "/" + title.total + "]" + title.url);
        if (title.total == blocks.size()) {
            List names = ServerStorage.SERVER_BLOCK_CACHE.getUsers(title.url);
            if (names == null) {
                return;
            }
            for (String uuid : names) {
                FileBackChannel.sendToPlayer(new FileInfoChannelPacket("true->" + title.url), player.f_8924_.m_6846_().m_11259_(UUID.fromString(uuid)));
                ChatImageCodeInstance.LOGGER.info("[echo to client(" + uuid + ")]" + title.url);
            }
            ChatImageCodeInstance.LOGGER.info("[FileChannel->Server]" + title.url);
        }
    }

    public static void clientDownloadFileChannelReceived(String res) {
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ClientStorage.CLIENT_CACHE_MAP.containsKey(title.url) ? (HashMap)ClientStorage.CLIENT_CACHE_MAP.get(title.url) : new HashMap();
        blocks.put(title.index, title);
        ClientStorage.CLIENT_CACHE_MAP.put(title.url, blocks);
        ChatImageCodeInstance.LOGGER.info("[DownloadFile(" + title.index + "/" + title.total + ")]" + title.url);
        if (blocks.size() == title.total) {
            NetworkHelper.mergeFileBlocks((String)title.url, (Map)blocks);
            ChatImageCodeInstance.LOGGER.info("[DownloadFileChannel-Merge]" + title.url);
        }
    }

    public static void clientFileInfoChannelReceived(String data) {
        String url = data.substring(6);
        ChatImageCodeInstance.LOGGER.info(url);
        if (data.startsWith("null")) {
            ChatImageCodeInstance.LOGGER.info("[GetFileChannel-NULL]{}", new Object[]{url});
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        } else if (data.startsWith("true")) {
            ChatImageCodeInstance.LOGGER.info("[GetFileChannel-Retry]{}", new Object[]{url});
            ChatImagePacket.loadFromServer(url);
        }
    }

    public static void serverFileInfoChannelReceived(ServerPlayer player, String url) {
        HashMap list = ServerStorage.SERVER_BLOCK_CACHE.getBlock(url);
        if (list != null) {
            for (Map.Entry entry : list.entrySet()) {
                ChatImageCodeInstance.LOGGER.debug("[GetFileChannel->Client:{}/{}]{}", new Object[]{entry.getKey(), list.size() - 1, url});
                DownloadFileChannel.sendToPlayer(new DownloadFileChannelPacket((String)entry.getValue()), player);
            }
            ChatImageCodeInstance.LOGGER.info("[GetFileChannel->Client]{}", new Object[]{url});
            return;
        }
        FileBackChannel.sendToPlayer(new FileInfoChannelPacket("null->" + url), player);
        ChatImageCodeInstance.LOGGER.error("[GetFileChannel]not found in server:{}", new Object[]{url});
        if (player != null) {
            ServerStorage.SERVER_BLOCK_CACHE.tryAddUser(url, player.m_20149_());
        }
        ChatImageCodeInstance.LOGGER.info("[GetFileChannel]\u8bb0\u5f55uuid:{}", new Object[]{player.m_20149_()});
        ChatImageCodeInstance.LOGGER.info("[not found in server]{}", new Object[]{url});
    }
}

