/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.integration;

import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.IClientAdapter;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.network.ChatImagePacket;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;

public class ChatImageClientAdapter
implements IClientAdapter {
    @Override
    public int getTimeOut() {
        return ChatImage.CONFIG.timeout;
    }

    public ChatImageFrame.TextureReader<ResourceLocation> loadTexture(InputStream image) throws IOException {
        NativeImage nativeImage = NativeImage.func_195713_a((InputStream)image);
        return new ChatImageFrame.TextureReader<ResourceLocation>(Minecraft.func_71410_x().func_110434_K().func_110578_a("chatimage/chatimage", new DynamicTexture(nativeImage)), nativeImage.func_195702_a(), nativeImage.func_195714_b());
    }

    @Override
    public void sendToServer(String url, File file, boolean isToServer) {
        if (isToServer) {
            List<String> bufs = NetworkHelper.createFilePacket(url, file);
            ChatImagePacket.sendFilePackets(bufs);
        } else {
            ChatImagePacket.loadFromServer(url);
        }
    }

    @Override
    public void checkCachePath() {
        File folder = new File(ChatImage.CONFIG.cachePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    @Override
    public int getMaxFileSize() {
        return ChatImage.CONFIG.MaxFileSize;
    }

    public IFormattableTextComponent getProcessMessage(int i) {
        return SimpleUtil.createTranslatableComponent("process.chatimage.message", i);
    }
}

