/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.tool;

import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import io.github.kituin.chatimage.tool.SimpleUtil;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;

public class ChatImageStyle {
    public static final HoverEvent.Action<ChatImageCode> SHOW_IMAGE = new HoverEvent.Action("show_chatimage", true, ChatImageCode::fromJson, ChatImageCode::toJson, ChatImageStyle::fromJson);

    public static ChatImageCode fromJson(ITextComponent text) {
        try {
            return ChatImageCodeInstance.createBuilder().fromCode(text.toString()).build();
        }
        catch (InvalidChatImageCodeException e) {
            return ChatImageCodeInstance.createBuilder().build();
        }
    }

    public static Style getStyleFromCode(ChatImageCode code) {
        return ChatImageStyle.getStyleFromCode(code, TextFormatting.GREEN);
    }

    public static Style getStyleFromCode(ChatImageCode code, TextFormatting color) {
        Style style = Style.field_240709_b_.func_240716_a_(new HoverEvent(SHOW_IMAGE, (Object)code));
        return style.func_240712_a_(color);
    }

    public static IFormattableTextComponent messageFromCode(ChatImageCode code) {
        IFormattableTextComponent t = code.messageFromCode(SimpleUtil::createLiteralComponent, SimpleUtil::createTranslatableComponent, IFormattableTextComponent::func_230529_a_);
        Style style = ChatImageStyle.getStyleFromCode(code);
        return t.func_230530_a_(style);
    }
}

