/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.integration;

import com.google.common.collect.Maps;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.IClientAdapter;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.chatimage.client.ChatImageClient;
import io.github.kituin.chatimage.network.ChatImagePacket;
import io.github.kituin.chatimage.network.FileChannelPacket;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class ChatImageClientAdapter
implements IClientAdapter {
    private final Map<String, Integer> dynamicIdCounters = Maps.newHashMap();

    public class_2960 registerDynamicTexture(String prefix, class_1043 texture) {
        Integer integer = this.dynamicIdCounters.get(prefix);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.dynamicIdCounters.put(prefix, integer);
        class_2960 identifier = class_2960.method_60656((String)String.format(Locale.ROOT, "dynamic/%s_%d", prefix, integer));
        class_310.method_1551().method_1531().method_4616(identifier, (class_1044)texture);
        return identifier;
    }

    public int getTimeOut() {
        return ChatImageClient.CONFIG.timeout;
    }

    public ChatImageFrame.TextureReader<class_2960> loadTexture(InputStream image) throws IOException {
        class_1011 nativeImage = class_1011.method_4309((InputStream)image);
        return new ChatImageFrame.TextureReader((Object)this.registerDynamicTexture(ChatImageClient.MOD_ID + "/chatimage", new class_1043(nativeImage)), nativeImage.method_4307(), nativeImage.method_4323());
    }

    public void sendToServer(String url, File file, boolean isToServer) {
        if (isToServer) {
            List stringList = NetworkHelper.createFilePacket((String)url, (File)file);
            ChatImagePacket.sendPacketAsync(FileChannelPacket::new, stringList);
        } else {
            ChatImagePacket.loadFromServer(url);
        }
    }

    public void checkCachePath() {
        File folder = new File(ChatImageClient.CONFIG.cachePath);
        if (!folder.exists()) {
            folder.mkdirs();
        }
    }

    public int getMaxFileSize() {
        return ChatImageClient.CONFIG.MaxFileSize;
    }

    public class_2561 getProcessMessage(int i) {
        return SimpleUtil.createTranslatableComponent("process.chatimage.message", i);
    }
}

