/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.paste;

import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.client.ChatImageClient;
import io.github.kituin.chatimage.paste.IPasteCompat;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.codec.digest.DigestUtils;

public class WindowsPasteCompat
implements IPasteCompat {
    private static final String TempFileType = "png";

    @Override
    public String doPaste() {
        try {
            Transferable trans = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
            if (trans == null) {
                return null;
            }
            if (trans.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                StringBuilder sb = new StringBuilder();
                Object object = trans.getTransferData(DataFlavor.javaFileListFlavor);
                if (object instanceof List) {
                    for (Object o : (List)object) {
                        sb.append(this.getImageCICode(o));
                    }
                    return sb.toString();
                }
            } else if (trans.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Object object = trans.getTransferData(DataFlavor.imageFlavor);
                return this.getImageCICode(object);
            }
        }
        catch (UnsupportedFlavorException | IOException | IllegalStateException e) {
            ChatImage.LOGGER.warn(e.getMessage());
        }
        return null;
    }

    private String getImageCICode(Object object) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (object instanceof File) {
            sb.append("[[CICode,url=file:///").append(((File)object).getPath()).append("]]");
        } else if (object instanceof BufferedImage) {
            BufferedImage image = (BufferedImage)object;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, TempFileType, baos);
            byte[] byteArr = baos.toByteArray();
            ChatImageCodeInstance.CLIENT_ADAPTER.checkCachePath();
            String fileName = ChatImageClient.CONFIG.cachePath + "/" + DigestUtils.md5Hex((byte[])byteArr) + ".png";
            File outputfile = new File(fileName);
            ImageIO.write((RenderedImage)image, TempFileType, outputfile);
            sb.append("[[CICode,url=file:///").append(outputfile.getAbsolutePath()).append("]]");
        } else {
            return null;
        }
        return sb.toString();
    }
}

