/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import com.google.gson.Gson;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.ChatImageCode.ServerStorage;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.network.DownloadFileChannelPacket;
import io.github.kituin.chatimage.network.FileChannelPacket;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ChatImagePacket {
    public static Gson gson = new Gson();

    public static void sendPacketAsync(class_3222 player, class_8710 packet) {
        CompletableFuture.supplyAsync(() -> {
            ServerPlayNetworking.send((class_3222)player, (class_8710)packet);
            return null;
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void sendPacketAsync(class_8710 packet) {
        CompletableFuture.supplyAsync(() -> {
            ClientPlayNetworking.send((class_8710)packet);
            return null;
        });
    }

    public static void sendPacketAsync(Function<String, class_8710> handler, List<String> bufs) {
        for (String buf : bufs) {
            ChatImagePacket.sendPacketAsync(handler.apply(buf));
        }
    }

    public static void loadFromServer(String url) {
        if (class_310.method_1551().field_1724 != null) {
            ChatImagePacket.sendPacketAsync(new FileInfoChannelPacket(url));
            ChatImage.LOGGER.info("[GetFileChannel-Try]{}", (Object)url);
        } else {
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        }
    }

    public static void serverFileChannelReceived(FileChannelPacket packet, ServerPlayNetworking.Context content) {
        MinecraftServer server = content.player().field_13995;
        String res = packet.message();
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ServerStorage.SERVER_BLOCK_CACHE.createBlock(title, res);
        ChatImage.LOGGER.info("[FileChannel->Server:{}/{}]{}", new Object[]{title.index, title.total, title.url});
        if (title.total == blocks.size()) {
            List names = ServerStorage.SERVER_BLOCK_CACHE.getUsers(title.url);
            if (names != null) {
                for (String uuid : names) {
                    class_3222 serverPlayer = server.method_3760().method_14602(UUID.fromString(uuid));
                    ChatImagePacket.sendPacketAsync(serverPlayer, new FileInfoChannelPacket("true->" + title.url));
                    ChatImage.LOGGER.info("[FileChannel->Client({})]{}", (Object)uuid, (Object)title.url);
                }
            }
            ChatImage.LOGGER.info("[FileChannel->Server]{}", (Object)title.url);
        }
    }

    public static void serverGetFileChannelReceived(FileInfoChannelPacket packet, ServerPlayNetworking.Context content) {
        class_3222 player = content.player();
        String url = packet.message();
        HashMap list = ServerStorage.SERVER_BLOCK_CACHE.getBlock(url);
        if (list != null) {
            for (Map.Entry entry : list.entrySet()) {
                ChatImagePacket.sendPacketAsync(player, new DownloadFileChannelPacket((String)entry.getValue()));
                ChatImage.LOGGER.debug("[GetFileChannel->Client:{}/{}]{}", new Object[]{entry.getKey(), list.size() - 1, url});
            }
            ChatImage.LOGGER.info("[GetFileChannel->Client]{}", (Object)url);
            return;
        }
        ChatImagePacket.sendPacketAsync(player, new FileInfoChannelPacket("null->" + url));
        ChatImage.LOGGER.error("[GetFileChannel]not found in server:{}", (Object)url);
        ServerStorage.SERVER_BLOCK_CACHE.tryAddUser(url, player.method_5845());
        ChatImage.LOGGER.info("[GetFileChannel]\u8bb0\u5f55uuid:{}", (Object)player.method_5845());
    }

    public static void clientGetFileChannelReceived(FileInfoChannelPacket packet) {
        String data = packet.message();
        String url = data.substring(6);
        ChatImage.LOGGER.info(url);
        if (data.startsWith("null")) {
            ChatImage.LOGGER.info("[GetFileChannel-NULL]{}", (Object)url);
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        } else if (data.startsWith("true")) {
            ChatImagePacket.loadFromServer(url);
        }
    }

    public static void clientDownloadFileChannelReceived(DownloadFileChannelPacket packet) {
        String res = packet.message();
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ClientStorage.CLIENT_CACHE_MAP.containsKey(title.url) ? (HashMap)ClientStorage.CLIENT_CACHE_MAP.get(title.url) : new HashMap();
        blocks.put(title.index, title);
        ClientStorage.CLIENT_CACHE_MAP.put(title.url, blocks);
        ChatImage.LOGGER.info("[DownloadFile({}/{})]{}", new Object[]{title.index, title.total, title.url});
        if (blocks.size() == title.total) {
            ChatImage.LOGGER.info(String.valueOf(blocks));
            NetworkHelper.mergeFileBlocks((String)title.url, (Map)blocks);
            ChatImage.LOGGER.info("[DownloadFileChannel-Merge]{}", (Object)title.url);
        }
    }
}

