/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.mixin;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageBoolean;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageCodeTool;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.ChatImageStyle;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={ChatComponent.class})
public class ChatComponentMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @ModifyVariable(at=@At(value="HEAD"), method={"addMessage(Lnet/minecraft/network/chat/Component;Lnet/minecraft/network/chat/MessageSignature;ILnet/minecraft/client/GuiMessageTag;Z)V"}, argsOnly=true)
    public Component addMessage(Component message) {
        if (ChatImage.CONFIG.experimentalTextComponentCompatibility) {
            StringBuilder sb = new StringBuilder();
            Component temp = this.chatImage$flattenTree(message, sb, false);
            ChatImageBoolean allString = new ChatImageBoolean(true);
            ChatImageCodeTool.sliceMsg((String)sb.toString(), (boolean)true, (ChatImageBoolean)allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
            if (!allString.isValue()) {
                message = temp;
            }
        }
        return this.chatimage$replaceMessage(message);
    }

    @Unique
    private ComponentContents chatImage$getContents(Component text) {
        return text.getContents();
    }

    @Unique
    private String chatImage$getText(ComponentContents text) {
        if (text instanceof LiteralContents) {
            return ((LiteralContents)text).text();
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Unique
    private Component chatimage$replaceCode(Component text) {
        MutableComponent mutableComponent;
        String checkedText;
        Style style;
        MutableComponent originText;
        boolean isSelf;
        MutableComponent player;
        String key;
        block13: {
            key = "";
            player = null;
            isSelf = false;
            originText = text.copy();
            originText.getSiblings().clear();
            style = text.getStyle();
            if (this.chatImage$getContents(text) instanceof LiteralContents) {
                checkedText = this.chatImage$getText((ComponentContents)((LiteralContents)this.chatImage$getContents(text)));
            } else {
                if (this.chatImage$getContents(text) instanceof TranslatableContents) {
                    TranslatableContents ttc = (TranslatableContents)this.chatImage$getContents(text);
                    key = ttc.getKey();
                    Object[] args = ttc.getArgs();
                    if (ChatImageCodeTool.checkKey((String)key)) {
                        MutableComponent contents;
                        player = (MutableComponent)args[0];
                        isSelf = this.chatImage$getContents((Component)player).toString().equals(this.chatImage$getContents(this.minecraft.player.getName()).toString());
                        checkedText = args[1] instanceof String ? (String)args[1] : (this.chatImage$getContents((Component)(contents = (MutableComponent)args[1])) instanceof LiteralContents ? this.chatImage$getText((ComponentContents)((LiteralContents)this.chatImage$getContents((Component)contents))) : this.chatImage$getContents((Component)contents).toString());
                        break block13;
                    } else {
                        ArrayList argTexts = Lists.newArrayList();
                        Object[] objectArray = args;
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            argTexts.add(this.chatimage$replaceMessage((Component)arg));
                            ++n2;
                        }
                        return SimpleUtil.createTranslatableComponent(key, argTexts.toArray()).setStyle(style);
                    }
                }
                checkedText = this.chatImage$getContents(text).toString();
            }
        }
        if (ChatImage.CONFIG.cqCode) {
            checkedText = ChatImageCodeTool.checkCQCode((String)checkedText);
        }
        ChatImageBoolean allString = new ChatImageBoolean(true);
        List texts = ChatImageCodeTool.sliceMsg((String)checkedText, (boolean)isSelf, (ChatImageBoolean)allString, e -> ChatImageCodeInstance.LOGGER.error(e.getMessage()));
        if (ChatImage.CONFIG.checkImageUri) {
            ChatImageCodeTool.checkImageUri((List)texts, (boolean)isSelf, (ChatImageBoolean)allString);
        }
        if (allString.isValue()) {
            ChatImageCode action;
            ChatImageCode chatImageCode = action = style.getHoverEvent() == null ? null : (ChatImageCode)style.getHoverEvent().getValue(ChatImageStyle.SHOW_IMAGE);
            if (action != null) {
                action.retry();
            }
            try {
                Component showText = style.getHoverEvent() == null ? null : (Component)style.getHoverEvent().getValue(HoverEvent.Action.SHOW_TEXT);
                if (showText == null) return originText;
                if (!(this.chatImage$getContents(showText) instanceof LiteralContents)) return originText;
                originText.setStyle(style.withHoverEvent(new HoverEvent(ChatImageStyle.SHOW_IMAGE, (Object)ChatImageCodeInstance.createBuilder().fromCode(this.chatImage$getText((ComponentContents)((LiteralContents)this.chatImage$getContents(showText)))).setIsSelf(isSelf).build())));
                return originText;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return originText;
        }
        MutableComponent res = SimpleUtil.createLiteralComponent("");
        ChatImageCodeTool.buildMsg((List)texts, obj -> res.append((Component)SimpleUtil.createLiteralComponent(obj).setStyle(style)), obj -> res.append((Component)ChatImageStyle.messageFromCode(obj)));
        if (player == null) {
            mutableComponent = res;
            return mutableComponent;
        }
        mutableComponent = SimpleUtil.createTranslatableComponent(key, player, res).setStyle(style);
        return mutableComponent;
    }

    @Unique
    private Component chatImage$flattenTree(Component node, StringBuilder mergedText, boolean openUrlStyle) {
        Style tempStyle = node.getStyle();
        if (this.chatImage$getContents(node) instanceof TranslatableContents) {
            TranslatableContents ttc = (TranslatableContents)this.chatImage$getContents(node);
            Object[] args = ttc.getArgs();
            ArrayList argsNew = Lists.newArrayList();
            for (Object arg : args) {
                argsNew.add(this.chatImage$flattenTree((Component)arg, mergedText, false));
            }
            return SimpleUtil.createTranslatableComponent(ttc.getKey(), argsNew.toArray()).setStyle(tempStyle);
        }
        String t = this.chatImage$getText(this.chatImage$getContents(node));
        mergedText.append(t);
        if (node.getSiblings().isEmpty()) {
            return node;
        }
        MutableComponent res = null;
        ArrayList children = Lists.newArrayList();
        StringBuilder childSb = new StringBuilder(t);
        for (int i = 0; i < node.getSiblings().size(); ++i) {
            boolean isLiteral;
            boolean check;
            Component child_;
            Component child = this.chatImage$flattenTree(child_, mergedText, (child_ = (Component)node.getSiblings().get(i)).getStyle().getClickEvent() != null && child_.getStyle().getClickEvent().getAction() == ClickEvent.Action.OPEN_URL);
            if (child == null) continue;
            Style childStyle = child.getStyle();
            if (tempStyle == null) {
                tempStyle = childStyle;
            }
            boolean bl = check = (isLiteral = this.chatImage$getContents(child) instanceof LiteralContents) && (childStyle == tempStyle || openUrlStyle || childStyle.getClickEvent() != null && childStyle.getClickEvent().getAction() == ClickEvent.Action.OPEN_URL);
            if (check) {
                childSb.append(this.chatImage$getText(this.chatImage$getContents(child)));
            }
            if (check && child.getSiblings().isEmpty() && i != node.getSiblings().size() - 1) continue;
            if (res == null) {
                res = SimpleUtil.createLiteralComponent(childSb.toString()).setStyle(tempStyle);
            } else {
                children.add(SimpleUtil.createLiteralComponent(childSb.toString()).setStyle(tempStyle));
            }
            if (!check) {
                children.add(child);
            }
            for (Component child__ : child.getSiblings()) {
                children.add(child__);
            }
            childSb = new StringBuilder();
            tempStyle = null;
        }
        for (Component child : children) {
            res.append(child);
        }
        return res;
    }

    @Unique
    private Component chatimage$replaceMessage(Component message) {
        try {
            MutableComponent res = (MutableComponent)this.chatimage$replaceCode(message);
            for (Component t : message.getSiblings()) {
                res.append(this.chatimage$replaceMessage(t));
            }
            return res;
        }
        catch (Exception e) {
            ChatImageCodeInstance.LOGGER.warn("\u8bc6\u522b\u5931\u8d25:{}", new Object[]{e.getMessage()});
            return message;
        }
    }
}

