/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import com.google.gson.Gson;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageIndex;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.NetworkHelper;
import io.github.kituin.ChatImageCode.ServerStorage;
import io.github.kituin.chatimage.network.DownloadFileChannelPacket;
import io.github.kituin.chatimage.network.FileChannelPacket;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatImagePacket {
    public static Gson gson = new Gson();
    private static final Logger LOGGER = LogManager.getLogger();

    public static void sendFilePackets(List<String> bufs) {
        for (String buf : bufs) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new FileChannelPacket(buf)});
        }
    }

    public static void loadFromServer(String url) {
        if (Minecraft.getInstance().player != null) {
            PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new FileInfoChannelPacket(url)});
            LOGGER.info("[try get from server]" + url);
        } else {
            ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
        }
    }

    public static void serverFileChannelReceived(ServerPlayer player, String res) {
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ServerStorage.SERVER_BLOCK_CACHE.createBlock(title, res);
        LOGGER.info("[FileChannel->Server:{}/{}]{}", (Object)title.index, (Object)title.total, (Object)title.url);
        if (title.total == blocks.size()) {
            List names = ServerStorage.SERVER_BLOCK_CACHE.getUsers(title.url);
            if (names != null) {
                for (String uuid : names) {
                    ServerPlayer serverPlayer = player.server.getPlayerList().getPlayer(UUID.fromString(uuid));
                    serverPlayer.connection.send((CustomPacketPayload)new FileInfoChannelPacket("true->" + title.url));
                    LOGGER.info("[echo to client(" + uuid + ")]" + title.url);
                }
            }
            LOGGER.info("[FileChannel->Server]" + title.url);
        }
    }

    public static void clientDownloadFileChannelReceived(String res) {
        ChatImageIndex title = (ChatImageIndex)gson.fromJson(res, ChatImageIndex.class);
        HashMap blocks = ClientStorage.CLIENT_CACHE_MAP.containsKey(title.url) ? (HashMap)ClientStorage.CLIENT_CACHE_MAP.get(title.url) : new HashMap();
        blocks.put(title.index, title);
        ClientStorage.CLIENT_CACHE_MAP.put(title.url, blocks);
        LOGGER.info("[DownloadFile(" + title.index + "/" + title.total + ")]" + title.url);
        if (blocks.size() == title.total) {
            NetworkHelper.mergeFileBlocks((String)title.url, (Map)blocks);
            LOGGER.info("[DownloadFileChannel-Merge]" + title.url);
        }
    }

    public static void serverFileInfoChannelReceived(ServerPlayer player, String url) {
        HashMap list = ServerStorage.SERVER_BLOCK_CACHE.getBlock(url);
        if (list != null) {
            for (Map.Entry entry : list.entrySet()) {
                LOGGER.debug("[GetFileChannel->Client:{}/{}]{}", entry.getKey(), (Object)(list.size() - 1), (Object)url);
                player.connection.send((CustomPacketPayload)new DownloadFileChannelPacket((String)entry.getValue()));
            }
            LOGGER.info("[GetFileChannel->Client]{}", (Object)url);
            return;
        }
        player.connection.send((CustomPacketPayload)new FileInfoChannelPacket("null->" + url));
        LOGGER.error("[GetFileChannel]not found in server:{}", (Object)url);
        if (player != null) {
            ServerStorage.SERVER_BLOCK_CACHE.tryAddUser(url, player.getStringUUID());
        }
        LOGGER.info("[GetFileChannel]\u8bb0\u5f55uuid:{}", (Object)player.getStringUUID());
        LOGGER.info("[not found in server]{}", (Object)url);
    }
}

