/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageConfig;
import io.github.kituin.chatimage.command.ChatImageCommand;
import io.github.kituin.chatimage.gui.ConfigScreen;
import io.github.kituin.chatimage.integration.ChatImageClientAdapter;
import io.github.kituin.chatimage.integration.ChatImageLogger;
import io.github.kituin.chatimage.network.ChatImagePacket;
import io.github.kituin.chatimage.network.DownloadFileChannelPacket;
import io.github.kituin.chatimage.network.FileInfoChannelPacket;
import io.github.kituin.chatimage.tool.SimpleUtil;
import java.io.File;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_304;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class ChatImageClient
implements ClientModInitializer {
    public static String MOD_ID = "chatimage";
    public static ChatImageConfig CONFIG;
    private static class_304 configKeyBinding;

    public void onInitializeClient() {
        configKeyBinding = KeyBindingHelper.registerKeyBinding((class_304)new class_304("config.chatimage.key", class_3675.class_307.field_1668, 269, "config.chatimage.category"));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (configKeyBinding.method_1436()) {
                SimpleUtil.setScreen(client, new ConfigScreen());
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"chatimage").executes(ChatImageCommand::help)).then(LiteralArgumentBuilder.literal((String)"send").then(RequiredArgumentBuilder.argument((String)"name", (ArgumentType)StringArgumentType.string()).then(RequiredArgumentBuilder.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(ChatImageCommand::sendChatImage))))).then(LiteralArgumentBuilder.literal((String)"url").then(RequiredArgumentBuilder.argument((String)"url", (ArgumentType)StringArgumentType.greedyString()).executes(ChatImageCommand::sendChatImage)))).then(LiteralArgumentBuilder.literal((String)"help").executes(ChatImageCommand::help))).then(LiteralArgumentBuilder.literal((String)"reload").executes(ChatImageCommand::reloadConfig))));
        ClientPlayNetworking.registerGlobalReceiver(DownloadFileChannelPacket.ID, (payload, context) -> ChatImagePacket.clientDownloadFileChannelReceived(payload));
        ClientPlayNetworking.registerGlobalReceiver(FileInfoChannelPacket.ID, (payload, context) -> ChatImagePacket.clientGetFileChannelReceived(payload));
    }

    static {
        ChatImageConfig.configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "chatimageconfig.json");
        CONFIG = ChatImageConfig.loadConfig();
        ChatImageCodeInstance.CLIENT_ADAPTER = new ChatImageClientAdapter();
        ChatImageCodeInstance.LOGGER = new ChatImageLogger();
    }
}

