/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.tool;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import org.jetbrains.annotations.Nullable;

public class ChatImageStyle {
    public static final MapCodec<ChatImageCode> MAP_CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Codec.STRING.fieldOf("url").forGetter(ChatImageCode::getUrl), (App)Codec.BOOL.optionalFieldOf("nsfw", (Object)false).forGetter(ChatImageCode::isNsfw)).apply((Applicative)obj, (url, nsfw) -> new ChatImageCode.Builder().setNsfw(nsfw.booleanValue()).setUrlForce(url).build()));
    public static final Codec<ChatImageCode> CODEC = MAP_CODEC.codec();
    public static final class_2568.class_5247<ChatImageCode> SHOW_IMAGE = new class_2568.class_5247("show_chatimage", true, CODEC, ChatImageStyle::legacySerializer);

    private static DataResult<ChatImageCode> legacySerializer(class_2561 text, @Nullable class_6903<?> ops) {
        try {
            return DataResult.success((Object)new ChatImageCode.Builder().fromCode(text.toString()).build());
        }
        catch (InvalidChatImageCodeException e) {
            return DataResult.error(() -> "Failed to parse ChatImageCode: " + e.getMessage());
        }
    }

    public static class_2583 getStyleFromCode(ChatImageCode code) {
        return ChatImageStyle.getStyleFromCode(code, class_124.field_1060);
    }

    public static class_2583 getStyleFromCode(ChatImageCode code, class_124 color) {
        class_2583 style = class_2583.field_24360.method_10949(new class_2568(SHOW_IMAGE, (Object)code));
        return style.method_10977(color);
    }

    public static class_5250 messageFromCode(ChatImageCode code) {
        class_5250 t = (class_5250)code.messageFromCode(class_2561::method_43470, class_2561::method_43471, class_5250::method_10852);
        class_2583 style = ChatImageStyle.getStyleFromCode(code);
        return t.method_27696(style);
    }
}

