/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.mixin;

import io.github.kituin.chatimage.ChatImage;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MouseHandler.class})
public class FileDragMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Inject(at={@At(value="RETURN")}, method={"onDrop"})
    private void onFilesDropped(long window, List<Path> paths, int p_350707_, CallbackInfo ci) {
        if (this.minecraft.screen != null && this.minecraft.screen instanceof ChatScreen && ChatImage.CONFIG.dragImage && this.minecraft.player != null) {
            StringBuilder sb = new StringBuilder();
            for (Path o : paths) {
                if (ChatImage.CONFIG.dragUseCicode) {
                    sb.append("[[CICode,url=file:///").append(o).append("]]");
                    continue;
                }
                sb.append("file:///").append(o);
            }
            this.minecraft.setScreen((Screen)new ChatScreen(sb.toString()));
        }
    }
}

