/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.network;

import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.chatimage.network.ChatImagePacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileInfoChannelPacket {
    public final String message;
    private static final Logger LOGGER = LogManager.getLogger();

    public FileInfoChannelPacket(FriendlyByteBuf buffer) {
        this.message = buffer.readUtf();
    }

    public FileInfoChannelPacket(String message) {
        this.message = message;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeUtf(this.message);
    }

    public static void handler(FileInfoChannelPacket packet, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            ServerPlayer player = ctx.getSender();
            ChatImagePacket.serverFileInfoChannelReceived(player, packet.message);
        });
        ctx.setPacketHandled(true);
    }

    public static void clientHandle(FileInfoChannelPacket packet, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> {
            String data = packet.message;
            String url = data.substring(6);
            LOGGER.info(url);
            if (data.startsWith("null")) {
                LOGGER.info("[GetFileChannel-NULL]" + url);
                ClientStorage.AddImageError((String)url, (ChatImageFrame.FrameError)ChatImageFrame.FrameError.FILE_NOT_FOUND);
            } else if (data.startsWith("true")) {
                LOGGER.info("[GetFileChannel-Retry]" + url);
                ChatImagePacket.loadFromServer(url);
            }
        });
        ctx.setPacketHandled(true);
    }
}

