/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.chatimage.ChatImage;
import io.github.kituin.chatimage.tool.ChatImageStyle;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.TooltipRenderUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.client.extensions.IGuiGraphicsExtension;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GuiGraphics.class})
public abstract class GuiGraphicsMixin
implements IGuiGraphicsExtension {
    @Shadow
    @Final
    private Minecraft minecraft;
    @Shadow
    @Final
    private PoseStack pose;

    @Shadow
    public abstract void drawManaged(Runnable var1);

    @Shadow
    public abstract void renderTooltip(Font var1, List<? extends FormattedCharSequence> var2, int var3, int var4);

    @Shadow
    public abstract void blit(ResourceLocation var1, int var2, int var3, float var4, float var5, int var6, int var7, int var8, int var9);

    @Shadow
    public abstract int guiWidth();

    @Shadow
    public abstract int guiHeight();

    @Inject(at={@At(value="RETURN")}, method={"renderComponentHoverEffect"})
    protected void renderComponentHoverEffect(Font p_282584_, @Nullable Style p_282156_, int p_283623_, int p_282114_, CallbackInfo ci) {
        HoverEvent hoverEvent;
        ChatImageCode code;
        if (p_282156_ != null && p_282156_.getHoverEvent() != null && (code = (ChatImageCode)(hoverEvent = p_282156_.getHoverEvent()).getValue(ChatImageStyle.SHOW_IMAGE)) != null) {
            if (ChatImage.CONFIG.nsfw || !code.isNsfw() || ClientStorage.ContainNsfw((String)code.getUrl())) {
                ChatImageFrame frame = code.getFrame();
                if (frame.loadImage(ChatImage.CONFIG.limitWidth, ChatImage.CONFIG.limitHeight)) {
                    int viewWidth = frame.getWidth();
                    int viewHeight = frame.getHeight();
                    int i = viewWidth + ChatImage.CONFIG.paddingLeft + ChatImage.CONFIG.paddingRight;
                    int j = viewHeight + ChatImage.CONFIG.paddingTop + ChatImage.CONFIG.paddingBottom;
                    int left = p_283623_ + 6;
                    int top = p_282114_ - 6;
                    int width = this.guiWidth();
                    int height = this.guiHeight();
                    if (left + i + 6 > width) {
                        left = width - i - 6;
                    }
                    if (top + j + 6 > height) {
                        top = height - j - 6;
                    }
                    this.pose.pushPose();
                    int finalL = left;
                    int finalM = top;
                    this.drawManaged(() -> TooltipRenderUtil.renderTooltipBackground((GuiGraphics)((GuiGraphics)this), (int)finalL, (int)finalM, (int)i, (int)j, (int)400));
                    this.pose.translate(0.0f, 0.0f, 400.0f);
                    this.blit((ResourceLocation)frame.getId(), left + ChatImage.CONFIG.paddingLeft, top + ChatImage.CONFIG.paddingTop, 0.0f, 0.0f, viewWidth, viewHeight, viewWidth, viewHeight);
                    this.pose.popPose();
                    frame.gifLoop(ChatImage.CONFIG.gifSpeed);
                } else {
                    MutableComponent text = (MutableComponent)frame.getErrorMessage(str -> Component.literal((String)((String)str)), str -> Component.translatable((String)((String)str)), (obj, s) -> ((MutableComponent)obj).append((Component)s), code);
                    this.renderTooltip(p_282584_, this.minecraft.font.split((FormattedText)text, Math.max(this.guiWidth() / 2, 200)), p_283623_, p_282114_);
                }
            } else {
                this.renderTooltip(p_282584_, this.minecraft.font.split((FormattedText)Component.translatable((String)"nsfw.chatimage.message"), Math.max(this.guiWidth() / 2, 200)), p_283623_, p_282114_);
            }
        }
    }
}

