/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.chatimage.tool;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.kituin.ChatImageCode.ChatImageCode;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public class ChatImageStyle {
    public static final MapCodec<ChatImageCode> MAP_CODEC = RecordCodecBuilder.mapCodec(obj -> obj.group((App)Codec.STRING.fieldOf("url").forGetter(ChatImageCode::getUrl), (App)Codec.BOOL.optionalFieldOf("nsfw", (Object)false).forGetter(ChatImageCode::isNsfw)).apply((Applicative)obj, (url, nsfw) -> new ChatImageCode.Builder().setNsfw(nsfw.booleanValue()).setUrlForce(url).build()));
    public static final Codec<ChatImageCode> CODEC = MAP_CODEC.codec();
    public static final HoverEvent.Action<ChatImageCode> SHOW_IMAGE = new HoverEvent.Action("show_chatimage", true, CODEC, (text, p_329862_) -> ChatImageStyle.legacySerializer(text));

    private static DataResult<ChatImageCode> legacySerializer(Component text) {
        try {
            return DataResult.success((Object)new ChatImageCode.Builder().fromCode(text.toString()).build());
        }
        catch (InvalidChatImageCodeException e) {
            return DataResult.error(() -> "Failed to parse ChatImageCode: " + e.getMessage());
        }
    }

    public static Style getStyleFromCode(ChatImageCode code) {
        return ChatImageStyle.getStyleFromCode(code, ChatFormatting.GREEN);
    }

    public static Style getStyleFromCode(ChatImageCode code, ChatFormatting color) {
        Style style = Style.EMPTY.withHoverEvent(new HoverEvent(SHOW_IMAGE, (Object)code));
        return style.withColor(color);
    }

    public static MutableComponent messageFromCode(ChatImageCode code) {
        MutableComponent t = (MutableComponent)code.messageFromCode(Component::literal, Component::translatable, MutableComponent::append);
        Style style = ChatImageStyle.getStyleFromCode(code);
        return t.setStyle(style);
    }

    public static ChatImageCode fromJson(Component text) {
        try {
            return ChatImageCodeInstance.createBuilder().fromCode(text.toString()).build();
        }
        catch (InvalidChatImageCodeException e) {
            return ChatImageCodeInstance.createBuilder().build();
        }
    }
}

