/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles;

import com.mojang.brigadier.CommandDispatcher;
import com.nethanialchorus.profiles.Config;
import com.nethanialchorus.profiles.command.ProfileCommands;
import com.nethanialchorus.profiles.network.ProfileNetworkHandler;
import com.nethanialchorus.profiles.profile.CharacterProfile;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="characterprofiles")
public class CharacterProfiles {
    public static final String MODID = "characterprofiles";

    public CharacterProfiles(IEventBus modEventBus, ModContainer modContainer) {
        CharacterProfile.ATTACHMENT_TYPES.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(this::registerNetworkHandlers);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void registerNetworkHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToClient(ProfileNetworkHandler.OpenProfileGuiPacket.TYPE, ProfileNetworkHandler.OpenProfileGuiPacket.STREAM_CODEC, ProfileNetworkHandler.OpenProfileGuiPacket::handle);
        registrar.playToServer(ProfileNetworkHandler.UpdateProfilePacket.TYPE, ProfileNetworkHandler.UpdateProfilePacket.STREAM_CODEC, ProfileNetworkHandler.UpdateProfilePacket::handle);
        registrar.playToClient(ProfileNetworkHandler.SyncProfilePacket.TYPE, ProfileNetworkHandler.SyncProfilePacket.STREAM_CODEC, ProfileNetworkHandler.SyncProfilePacket::handle);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        ProfileCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerJoinWorld(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CharacterProfile.syncToSelf(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newPlayer = (ServerPlayer)player;
            player = event.getOriginal();
            if (player instanceof ServerPlayer) {
                ServerPlayer oldPlayer = (ServerPlayer)player;
                CharacterProfile.getProfile(oldPlayer).ifPresent(profile -> {
                    CharacterProfile.setProfile(newPlayer, profile);
                    CharacterProfile.syncToSelf(newPlayer);
                });
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CharacterProfile.syncToSelf(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onPlayerStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CharacterProfile.syncToSelf(serverPlayer);
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (!event.getLevel().isClientSide) {
                CharacterProfile.syncToSelf(serverPlayer);
            }
        }
    }
}

