/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.BooleanValue ALLOW_NAME_VIEWING = BUILDER.comment("Whether other players can view character names").define("allowNameViewing", true);
    public static final ModConfigSpec.BooleanValue ALLOW_AGE_VIEWING = BUILDER.comment("Whether other players can view character ages").define("allowAgeViewing", true);
    public static final ModConfigSpec.BooleanValue ALLOW_DESCRIPTION_VIEWING = BUILDER.comment("Whether other players can view character descriptions").define("allowDescriptionViewing", true);
    public static final ModConfigSpec.BooleanValue ALLOW_CLASS_VIEWING = BUILDER.comment("Whether other players can view character classes").define("allowClassViewing", true);
    public static final ModConfigSpec.BooleanValue ALLOW_TRAITS_VIEWING = BUILDER.comment("Whether other players can view character traits").define("allowTraitsViewing", true);
    public static final ModConfigSpec.IntValue MAX_NAME_LENGTH = BUILDER.comment("Maximum length for character names").defineInRange("maxNameLength", 32, 1, 100);
    public static final ModConfigSpec.IntValue MAX_DESCRIPTION_LENGTH = BUILDER.comment("Maximum length for character descriptions").defineInRange("maxDescriptionLength", 500, 1, 2000);
    public static final ModConfigSpec.IntValue MAX_CLASS_LENGTH = BUILDER.comment("Maximum length for character class").defineInRange("maxClassLength", 32, 1, 100);
    public static final ModConfigSpec.IntValue MAX_TRAITS_LENGTH = BUILDER.comment("Maximum length for character traits").defineInRange("maxTraitsLength", 300, 1, 1000);
    public static final ModConfigSpec.IntValue MIN_AGE = BUILDER.comment("Minimum character age").defineInRange("minAge", 1, 1, 10000);
    public static final ModConfigSpec.IntValue MAX_AGE = BUILDER.comment("Maximum character age").defineInRange("maxAge", 10000, 1, 100000);
    static final ModConfigSpec SPEC = BUILDER.build();

    private static boolean validateItemName(Object obj) {
        String itemName;
        return obj instanceof String && BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)(itemName = (String)obj)));
    }
}

