/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles.client.gui;

import com.nethanialchorus.profiles.Config;
import com.nethanialchorus.profiles.client.gui.ProfileImageButton;
import com.nethanialchorus.profiles.network.ProfileNetworkHandler;
import com.nethanialchorus.profiles.profile.CharacterProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class CharacterProfileScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"textures/gui/scroll_container_bg.png");
    private static final ResourceLocation EDIT_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"draft_report");
    private static final ResourceLocation EDIT_HIGHLIGHTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"draft_report_highlighted");
    private static final ResourceLocation ACCEPT_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"accept");
    private static final ResourceLocation ACCEPT_HIGHLIGHTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"accept_highlighted");
    private static final ResourceLocation REJECT_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"reject");
    private static final ResourceLocation REJECT_HIGHLIGHTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"reject_highlighted");
    private static final ResourceLocation CLOSE_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"close");
    private static final ResourceLocation EYE_OPEN_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"eye_open");
    private static final ResourceLocation EYE_OPEN_HIGHLIGHTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"eye_open_highlighted");
    private static final ResourceLocation EYE_CLOSED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"eye_closed");
    private static final ResourceLocation EYE_CLOSED_HIGHLIGHTED_ICON = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"eye_closed_highlighted");
    private static final WidgetSprites EDIT_SPRITES = new WidgetSprites(EDIT_ICON, EDIT_HIGHLIGHTED_ICON);
    private static final WidgetSprites ACCEPT_SPRITES = new WidgetSprites(ACCEPT_ICON, ACCEPT_HIGHLIGHTED_ICON);
    private static final WidgetSprites REJECT_SPRITES = new WidgetSprites(REJECT_ICON, REJECT_HIGHLIGHTED_ICON);
    private static final WidgetSprites CLOSE_SPRITES = new WidgetSprites(CLOSE_ICON, CLOSE_ICON);
    private static final WidgetSprites EYE_OPEN_SPRITES = new WidgetSprites(EYE_OPEN_ICON, EYE_OPEN_ICON);
    private static final WidgetSprites EYE_CLOSED_SPRITES = new WidgetSprites(EYE_CLOSED_ICON, EYE_CLOSED_ICON);
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MIN_GUI_WIDTH = 256;
    private static final int MIN_GUI_HEIGHT = 256;
    private static final int PADDING = 30;
    private final CharacterProfile profile;
    private final boolean isOwnProfile;
    private boolean isEditMode = false;
    private String originalName;
    private int originalAge;
    private String originalDescription;
    private String originalClass;
    private List<String> originalTraits;
    private boolean originalNameVisible;
    private boolean originalAgeVisible;
    private boolean originalDescriptionVisible;
    private boolean originalClassVisible;
    private boolean originalTraitsVisible;
    private EditBox nameBox;
    private EditBox ageBox;
    private EditBox descriptionBox;
    private EditBox classBox;
    private List<EditBox> traitBoxes = new ArrayList<EditBox>();
    private List<ProfileImageButton> traitRemoveButtons = new ArrayList<ProfileImageButton>();
    private ProfileImageButton editButton;
    private ProfileImageButton saveButton;
    private ProfileImageButton cancelButton;
    private Button addTraitButton;
    private Button closeButton;
    private ProfileImageButton namePrivacyButton;
    private ProfileImageButton agePrivacyButton;
    private ProfileImageButton descriptionPrivacyButton;
    private ProfileImageButton classPrivacyButton;
    private ProfileImageButton traitsPrivacyButton;
    private int leftPos;
    private int topPos;
    private int guiWidth;
    private int guiHeight;

    public CharacterProfileScreen(CharacterProfile profile, boolean isOwnProfile) {
        super((Component)Component.literal((String)"Character Profile"));
        this.profile = profile;
        this.isOwnProfile = isOwnProfile;
        this.originalName = profile.getName();
        this.originalAge = profile.getAge();
        this.originalDescription = profile.getDescription();
        this.originalClass = profile.getCharacterClass();
        this.originalTraits = new ArrayList<String>(profile.getTraits());
        this.originalNameVisible = profile.isNameVisible();
        this.originalAgeVisible = profile.isAgeVisible();
        this.originalDescriptionVisible = profile.isDescriptionVisible();
        this.originalClassVisible = profile.isClassVisible();
        this.originalTraitsVisible = profile.isTraitsVisible();
    }

    protected void init() {
        this.guiWidth = Math.max(256, Math.min(this.width - 40, 400));
        this.guiHeight = Math.max(256, Math.min(this.height - 40, 500));
        int screenWidth = this.width;
        int screenHeight = this.height;
        int maxSize = Math.min(256, screenHeight);
        int backgroundX = (screenWidth - maxSize) / 2;
        int backgroundY = (screenHeight - maxSize) / 2;
        this.leftPos = backgroundX + (maxSize - this.guiWidth) / 2;
        this.topPos = backgroundY + (maxSize - this.guiHeight) / 2;
        this.initializeComponents();
        this.updateEditMode();
    }

    private void initializeComponents() {
        WidgetSprites eyeSprites;
        this.clearWidgets();
        this.traitBoxes.clear();
        this.traitRemoveButtons.clear();
        int yOffset = 40;
        int contentWidth = Math.min(this.guiWidth - 60, 200);
        int leftMargin = 60;
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_NAME_VIEWING.get()).booleanValue() && this.profile.isNameVisible()) {
            this.nameBox = new EditBox(this.font, this.leftPos + 30 + leftMargin, this.topPos + yOffset, contentWidth, 16, (Component)Component.literal((String)"Name"));
            this.nameBox.setMaxLength(((Integer)Config.MAX_NAME_LENGTH.get()).intValue());
            this.nameBox.setValue(this.profile.getName());
            this.nameBox.setBordered(false);
            this.addRenderableWidget((GuiEventListener)this.nameBox);
            if (this.isOwnProfile) {
                eyeSprites = this.profile.isNameVisible() ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
                this.namePrivacyButton = new ProfileImageButton(this.leftPos + leftMargin + contentWidth + 5, this.topPos + yOffset, 16, 16, eyeSprites, button -> this.toggleNamePrivacy(), (Component)Component.literal((String)(this.profile.isNameVisible() ? "Name is visible to others" : "Name is hidden from others")));
                this.namePrivacyButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggle Visibility")));
                this.addRenderableWidget((GuiEventListener)this.namePrivacyButton);
            }
            yOffset += 25;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_AGE_VIEWING.get()).booleanValue() && this.profile.isAgeVisible()) {
            this.ageBox = new EditBox(this.font, this.leftPos + 30 + leftMargin, this.topPos + yOffset, contentWidth, 16, (Component)Component.literal((String)"Age"));
            this.ageBox.setValue(String.valueOf(this.profile.getAge()));
            this.ageBox.setBordered(false);
            this.addRenderableWidget((GuiEventListener)this.ageBox);
            if (this.isOwnProfile) {
                eyeSprites = this.profile.isAgeVisible() ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
                this.agePrivacyButton = new ProfileImageButton(this.leftPos + leftMargin + contentWidth + 5, this.topPos + yOffset, 16, 16, eyeSprites, button -> this.toggleAgePrivacy(), (Component)Component.literal((String)(this.profile.isAgeVisible() ? "Age is visible to others" : "Age is hidden from others")));
                this.agePrivacyButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggle Visibility")));
                this.addRenderableWidget((GuiEventListener)this.agePrivacyButton);
            }
            yOffset += 25;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_CLASS_VIEWING.get()).booleanValue() && this.profile.isClassVisible()) {
            this.classBox = new EditBox(this.font, this.leftPos + 30 + leftMargin, this.topPos + yOffset, contentWidth, 16, (Component)Component.literal((String)"Class"));
            this.classBox.setMaxLength(((Integer)Config.MAX_CLASS_LENGTH.get()).intValue());
            this.classBox.setValue(this.profile.getCharacterClass());
            this.classBox.setBordered(false);
            this.addRenderableWidget((GuiEventListener)this.classBox);
            if (this.isOwnProfile) {
                eyeSprites = this.profile.isClassVisible() ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
                this.classPrivacyButton = new ProfileImageButton(this.leftPos + leftMargin + contentWidth + 5, this.topPos + yOffset, 16, 16, eyeSprites, button -> this.toggleClassPrivacy(), (Component)Component.literal((String)(this.profile.isClassVisible() ? "Class is visible to others" : "Class is hidden from others")));
                this.classPrivacyButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggle Visibility")));
                this.addRenderableWidget((GuiEventListener)this.classPrivacyButton);
            }
            yOffset += 25;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_DESCRIPTION_VIEWING.get()).booleanValue() && this.profile.isDescriptionVisible()) {
            int descriptionLines = this.calculateDescriptionLines(this.profile.getDescription(), contentWidth);
            int descriptionHeight = Math.max(40, Math.min(80, descriptionLines * 10 + 10));
            this.descriptionBox = new EditBox(this.font, this.leftPos + 30 + leftMargin, this.topPos + yOffset, contentWidth, descriptionHeight, (Component)Component.literal((String)"Description"));
            this.descriptionBox.setMaxLength(((Integer)Config.MAX_DESCRIPTION_LENGTH.get()).intValue());
            this.descriptionBox.setValue(this.profile.getDescription());
            this.descriptionBox.setBordered(false);
            this.addRenderableWidget((GuiEventListener)this.descriptionBox);
            if (this.isOwnProfile) {
                WidgetSprites eyeSprites2 = this.profile.isDescriptionVisible() ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
                this.descriptionPrivacyButton = new ProfileImageButton(this.leftPos + leftMargin + contentWidth + 5, this.topPos + yOffset, 16, 16, eyeSprites2, button -> this.toggleDescriptionPrivacy(), (Component)Component.literal((String)(this.profile.isDescriptionVisible() ? "Description is visible to others" : "Description is hidden from others")));
                this.descriptionPrivacyButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggle Visibility")));
                this.addRenderableWidget((GuiEventListener)this.descriptionPrivacyButton);
            }
            yOffset += descriptionHeight + 15;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_TRAITS_VIEWING.get()).booleanValue() && this.profile.isTraitsVisible()) {
            yOffset -= 5;
            List<String> traits = this.profile.getTraits();
            for (int i = 0; i < Math.min(traits.size(), 5); ++i) {
                EditBox traitBox = new EditBox(this.font, this.leftPos + leftMargin + 15 + 15, this.topPos + yOffset, contentWidth - 35, 16, (Component)Component.literal((String)("Trait " + (i + 1))));
                traitBox.setMaxLength(50);
                traitBox.setValue(traits.get(i));
                traitBox.setBordered(false);
                this.traitBoxes.add(traitBox);
                this.addRenderableWidget((GuiEventListener)traitBox);
                if (this.isOwnProfile) {
                    int finalI = i;
                    ProfileImageButton removeButton = (ProfileImageButton)this.addRenderableWidget((GuiEventListener)new ProfileImageButton(this.leftPos + leftMargin + 15 + contentWidth - 25 + 10, this.topPos + yOffset, 18, 18, CLOSE_SPRITES, button -> this.onRemoveTrait(finalI), (Component)Component.literal((String)"Remove Trait")));
                    removeButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Remove Trait")));
                    this.traitRemoveButtons.add(removeButton);
                }
                yOffset += 15;
            }
            if (this.isOwnProfile && !traits.isEmpty()) {
                WidgetSprites eyeSprites3 = this.profile.isTraitsVisible() ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
                this.traitsPrivacyButton = new ProfileImageButton(this.leftPos + leftMargin + contentWidth + 5, this.topPos + yOffset - traits.size() * 15 - 5, 16, 16, eyeSprites3, button -> this.toggleTraitsPrivacy(), (Component)Component.literal((String)(this.profile.isTraitsVisible() ? "Traits are visible to others" : "Traits are hidden from others")));
                this.traitsPrivacyButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Toggle Visibility")));
                this.addRenderableWidget((GuiEventListener)this.traitsPrivacyButton);
            }
            if (this.isOwnProfile && traits.size() < 5) {
                this.addTraitButton = Button.builder((Component)Component.literal((String)"+ Add Trait"), this::onAddTrait).bounds(this.leftPos + 30 + leftMargin + 15, this.topPos + yOffset, 80, 16).build();
                this.addRenderableWidget((GuiEventListener)this.addTraitButton);
                yOffset += 25;
            }
        }
        if (this.isOwnProfile) {
            this.editButton = new ProfileImageButton(this.leftPos + this.guiWidth - 110, this.topPos + 10, 18, 18, EDIT_SPRITES, this::onEditPressed, (Component)Component.literal((String)"Edit"));
            this.editButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Edit Profile")));
            this.addRenderableWidget((GuiEventListener)this.editButton);
            this.saveButton = new ProfileImageButton(this.leftPos + this.guiWidth - 125, this.topPos + 10, 18, 18, ACCEPT_SPRITES, this::onSavePressed, (Component)Component.literal((String)"Save"));
            this.saveButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Save Changes")));
            this.addRenderableWidget((GuiEventListener)this.saveButton);
            this.cancelButton = new ProfileImageButton(this.leftPos + this.guiWidth - 110, this.topPos + 10, 18, 18, REJECT_SPRITES, this::onCancelPressed, (Component)Component.literal((String)"Cancel"));
            this.cancelButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Cancel Changes")));
            this.addRenderableWidget((GuiEventListener)this.cancelButton);
        }
    }

    private int calculateDescriptionLines(String text, int maxWidth) {
        List<String> lines = this.wrapText(text, maxWidth);
        return Math.max(1, lines.size());
    }

    private void updateEditMode() {
        boolean editable;
        boolean bl = editable = this.isOwnProfile && this.isEditMode;
        if (this.nameBox != null) {
            this.nameBox.setEditable(editable);
            this.nameBox.setBordered(editable);
            this.nameBox.setVisible(editable || !this.isOwnProfile && this.profile.isNameVisible());
        }
        if (this.ageBox != null) {
            this.ageBox.setEditable(editable);
            this.ageBox.setBordered(editable);
            this.ageBox.setVisible(editable || !this.isOwnProfile && this.profile.isAgeVisible());
        }
        if (this.descriptionBox != null) {
            this.descriptionBox.setEditable(editable);
            this.descriptionBox.setBordered(editable);
            this.descriptionBox.setVisible(editable || !this.isOwnProfile && this.profile.isDescriptionVisible());
        }
        if (this.classBox != null) {
            this.classBox.setEditable(editable);
            this.classBox.setBordered(editable);
            this.classBox.setVisible(editable || !this.isOwnProfile && this.profile.isClassVisible());
        }
        for (EditBox traitBox : this.traitBoxes) {
            traitBox.setEditable(editable);
            traitBox.setBordered(editable);
            traitBox.setVisible(editable || !this.isOwnProfile && this.profile.isTraitsVisible());
        }
        if (this.isOwnProfile) {
            this.editButton.visible = !editable;
            this.saveButton.visible = editable;
            this.cancelButton.visible = editable;
            if (this.namePrivacyButton != null) {
                boolean bl2 = this.namePrivacyButton.visible = !editable;
            }
            if (this.agePrivacyButton != null) {
                boolean bl3 = this.agePrivacyButton.visible = !editable;
            }
            if (this.descriptionPrivacyButton != null) {
                boolean bl4 = this.descriptionPrivacyButton.visible = !editable;
            }
            if (this.classPrivacyButton != null) {
                boolean bl5 = this.classPrivacyButton.visible = !editable;
            }
            if (this.traitsPrivacyButton != null) {
                this.traitsPrivacyButton.visible = !editable;
            }
        }
        for (ProfileImageButton removeButton : this.traitRemoveButtons) {
            removeButton.visible = editable;
        }
        if (this.addTraitButton != null) {
            this.addTraitButton.visible = editable && this.traitBoxes.size() < 5;
        }
    }

    private void toggleNamePrivacy() {
        this.profile.setNameVisible(!this.profile.isNameVisible());
        this.updatePrivacyButton(this.namePrivacyButton, this.profile.isNameVisible(), "Name");
        this.sendPrivacyUpdate();
        this.originalNameVisible = this.profile.isNameVisible();
    }

    private void toggleAgePrivacy() {
        this.profile.setAgeVisible(!this.profile.isAgeVisible());
        this.updatePrivacyButton(this.agePrivacyButton, this.profile.isAgeVisible(), "Age");
        this.sendPrivacyUpdate();
        this.originalAgeVisible = this.profile.isAgeVisible();
    }

    private void toggleDescriptionPrivacy() {
        this.profile.setDescriptionVisible(!this.profile.isDescriptionVisible());
        this.updatePrivacyButton(this.descriptionPrivacyButton, this.profile.isDescriptionVisible(), "Description");
        this.sendPrivacyUpdate();
        this.originalDescriptionVisible = this.profile.isDescriptionVisible();
    }

    private void toggleClassPrivacy() {
        this.profile.setClassVisible(!this.profile.isClassVisible());
        this.updatePrivacyButton(this.classPrivacyButton, this.profile.isClassVisible(), "Class");
        this.sendPrivacyUpdate();
        this.originalClassVisible = this.profile.isClassVisible();
    }

    private void toggleTraitsPrivacy() {
        this.profile.setTraitsVisible(!this.profile.isTraitsVisible());
        this.updatePrivacyButton(this.traitsPrivacyButton, this.profile.isTraitsVisible(), "Traits");
        this.sendPrivacyUpdate();
        this.originalTraitsVisible = this.profile.isTraitsVisible();
    }

    private void sendPrivacyUpdate() {
        if (!this.isOwnProfile) {
            return;
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new ProfileNetworkHandler.UpdateProfilePacket(this.profile.getName(), this.profile.getAge(), this.profile.getDescription(), this.profile.getCharacterClass(), this.profile.getTraits(), this.profile.isNameVisible(), this.profile.isAgeVisible(), this.profile.isDescriptionVisible(), this.profile.isClassVisible(), this.profile.isTraitsVisible()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void updatePrivacyButton(ProfileImageButton button, boolean isVisible, String fieldName) {
        if (button != null) {
            button.sprites = isVisible ? EYE_OPEN_SPRITES : EYE_CLOSED_SPRITES;
            button.setMessage((Component)Component.literal((String)(fieldName + (isVisible ? " is visible to others" : " is hidden from others"))));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTiledBackground(guiGraphics);
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int maxSize = Math.min(256, screenHeight);
        int backgroundX = screenWidth / 2 - 128;
        int backgroundY = screenHeight / 2 - 128;
        int centeredLeftPos = backgroundX + (256 - this.guiWidth) / 2;
        int centeredTopPos = backgroundY + (256 - this.guiHeight) / 2;
        int leftMargin = 60;
        int contentWidth = Math.min(this.guiWidth - 60, 180);
        String title = "Character Profile";
        int titleWidth = this.font.width(title);
        guiGraphics.drawString(this.font, title, centeredLeftPos + (this.guiWidth - titleWidth) / 2, centeredTopPos + 15, 4138009, false);
        int yOffset = 40;
        if ((this.isOwnProfile || ((Boolean)Config.ALLOW_NAME_VIEWING.get()).booleanValue() && this.profile.isNameVisible()) && !this.isEditMode) {
            guiGraphics.drawString(this.font, "Name: " + this.profile.getName(), centeredLeftPos + 30 + leftMargin, centeredTopPos + yOffset + 4, 4138009, false);
            yOffset += 25;
        } else if (this.isOwnProfile || ((Boolean)Config.ALLOW_NAME_VIEWING.get()).booleanValue() && this.profile.isNameVisible()) {
            yOffset += 25;
        }
        if ((this.isOwnProfile || ((Boolean)Config.ALLOW_AGE_VIEWING.get()).booleanValue() && this.profile.isAgeVisible()) && !this.isEditMode) {
            String ageText = "Age: " + this.profile.getAge();
            guiGraphics.drawString(this.font, ageText, centeredLeftPos + 30 + leftMargin, centeredTopPos + yOffset + 4, 4138009, false);
            yOffset += 25;
        } else if (this.isOwnProfile || ((Boolean)Config.ALLOW_AGE_VIEWING.get()).booleanValue() && this.profile.isAgeVisible()) {
            yOffset += 25;
        }
        if ((this.isOwnProfile || ((Boolean)Config.ALLOW_CLASS_VIEWING.get()).booleanValue() && this.profile.isClassVisible()) && !this.isEditMode) {
            String classText = "Class: " + this.profile.getCharacterClass();
            guiGraphics.drawString(this.font, classText, centeredLeftPos + 30 + leftMargin, centeredTopPos + yOffset + 4, 4138009, false);
            yOffset += 25;
        } else if (this.isOwnProfile || ((Boolean)Config.ALLOW_CLASS_VIEWING.get()).booleanValue() && this.profile.isClassVisible()) {
            yOffset += 25;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_DESCRIPTION_VIEWING.get()).booleanValue() && this.profile.isDescriptionVisible()) {
            if (!this.isEditMode) {
                int descriptionHeight = this.renderWrappedText(guiGraphics, this.profile.getDescription(), centeredLeftPos + 30 + leftMargin, centeredTopPos + yOffset, contentWidth, 4138009);
                yOffset += descriptionHeight + 15;
            } else {
                int descriptionLines = this.calculateDescriptionLines(this.profile.getDescription(), contentWidth);
                int descriptionHeight = Math.max(40, Math.min(80, descriptionLines * 10 + 10));
                yOffset += descriptionHeight + 15;
            }
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_TRAITS_VIEWING.get()).booleanValue() && this.profile.isTraitsVisible()) {
            yOffset += 10;
            if (!this.isEditMode) {
                guiGraphics.drawString(this.font, "Traits:", centeredLeftPos + 30 + leftMargin, centeredTopPos + yOffset - 5, 4138009, false);
                List<String> traits = this.profile.getTraits();
                for (String trait : traits) {
                    if (trait.trim().isEmpty()) continue;
                    guiGraphics.drawString(this.font, "\u2022 " + trait, centeredLeftPos + 30 + leftMargin + 15, centeredTopPos + yOffset + 8, 4138009, false);
                    yOffset += 16;
                }
            }
        }
    }

    private void renderTiledBackground(GuiGraphics guiGraphics) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int maxSize = Math.min(256, screenHeight);
        int drawX = screenWidth / 2 - 128;
        int drawY = screenHeight / 2 - 128;
        guiGraphics.blit(BACKGROUND_TEXTURE, drawX, drawY, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    private int renderWrappedText(GuiGraphics guiGraphics, String text, int x, int y, int maxWidth, int color) {
        List<String> lines = this.wrapText(text, maxWidth);
        for (int i = 0; i < lines.size(); ++i) {
            guiGraphics.drawString(this.font, lines.get(i), x, y + i * 10, color, false);
        }
        return lines.size() * 10;
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.font.width(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private void onEditPressed(Button button) {
        this.isEditMode = true;
        this.updateEditMode();
    }

    private void onSavePressed(Button button) {
        if (!this.isOwnProfile) {
            return;
        }
        try {
            String name = this.nameBox != null ? this.nameBox.getValue() : this.profile.getName();
            int age = this.ageBox != null ? Integer.parseInt(this.ageBox.getValue()) : this.profile.getAge();
            String description = this.descriptionBox != null ? this.descriptionBox.getValue() : this.profile.getDescription();
            String characterClass = this.classBox != null ? this.classBox.getValue() : this.profile.getCharacterClass();
            ArrayList<String> traits = new ArrayList<String>();
            for (EditBox traitBox : this.traitBoxes) {
                String trait = traitBox.getValue().trim();
                if (trait.isEmpty()) continue;
                traits.add(trait);
            }
            if (age < (Integer)Config.MIN_AGE.get() || age > (Integer)Config.MAX_AGE.get()) {
                return;
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new ProfileNetworkHandler.UpdateProfilePacket(name, age, description, characterClass, traits, this.profile.isNameVisible(), this.profile.isAgeVisible(), this.profile.isDescriptionVisible(), this.profile.isClassVisible(), this.profile.isTraitsVisible()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.profile.setName(name);
            this.profile.setAge(age);
            this.profile.setDescription(description);
            this.profile.setCharacterClass(characterClass);
            this.profile.setTraits(traits);
            this.originalName = name;
            this.originalAge = age;
            this.originalDescription = description;
            this.originalClass = characterClass;
            this.originalTraits = new ArrayList<String>(traits);
            this.originalNameVisible = this.profile.isNameVisible();
            this.originalAgeVisible = this.profile.isAgeVisible();
            this.originalDescriptionVisible = this.profile.isDescriptionVisible();
            this.originalClassVisible = this.profile.isClassVisible();
            this.originalTraitsVisible = this.profile.isTraitsVisible();
            this.isEditMode = false;
            this.updateEditMode();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void onCancelPressed(Button button) {
        this.profile.setName(this.originalName);
        this.profile.setAge(this.originalAge);
        this.profile.setDescription(this.originalDescription);
        this.profile.setCharacterClass(this.originalClass);
        this.profile.setTraits(new ArrayList<String>(this.originalTraits));
        this.profile.setNameVisible(this.originalNameVisible);
        this.profile.setAgeVisible(this.originalAgeVisible);
        this.profile.setDescriptionVisible(this.originalDescriptionVisible);
        this.profile.setClassVisible(this.originalClassVisible);
        this.profile.setTraitsVisible(this.originalTraitsVisible);
        this.isEditMode = false;
        this.init();
    }

    private void onAddTrait(Button button) {
        if (this.traitBoxes.size() < 5) {
            ArrayList<String> currentTraitValues = new ArrayList<String>();
            for (EditBox traitBox : this.traitBoxes) {
                currentTraitValues.add(traitBox.getValue());
            }
            this.profile.setTraits(currentTraitValues);
            this.profile.getTraits().add("");
            this.init();
        }
    }

    private void onRemoveTrait(int index) {
        if (index >= 0 && index < this.profile.getTraits().size()) {
            ArrayList<String> currentTraitValues = new ArrayList<String>();
            for (EditBox traitBox : this.traitBoxes) {
                currentTraitValues.add(traitBox.getValue());
            }
            currentTraitValues.remove(index);
            this.profile.setTraits(currentTraitValues);
            this.init();
        }
    }

    public boolean isPauseScreen() {
        return false;
    }
}

