/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles.client.gui;

import com.nethanialchorus.profiles.Config;
import com.nethanialchorus.profiles.profile.CharacterProfile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CharacterProfileViewScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"textures/gui/scroll_container_bg.png");
    private static final int TEXTURE_WIDTH = 256;
    private static final int TEXTURE_HEIGHT = 256;
    private static final int MIN_GUI_WIDTH = 256;
    private static final int MIN_GUI_HEIGHT = 256;
    private static final int PADDING = 30;
    private final CharacterProfile profile;
    private final boolean isOwnProfile;
    private final String ownerName;
    private int leftPos;
    private int topPos;
    private int guiWidth;
    private int guiHeight;

    public CharacterProfileViewScreen(CharacterProfile profile, boolean isOwnProfile, String ownerName) {
        super((Component)Component.literal((String)"Character Profile"));
        this.profile = profile;
        this.isOwnProfile = isOwnProfile;
        this.ownerName = ownerName != null ? ownerName : "Unknown Player";
    }

    protected void init() {
        this.guiWidth = Math.max(256, Math.min(this.width - 40, 400));
        this.guiHeight = Math.max(256, Math.min(this.height - 40, 500));
        int screenWidth = this.width;
        int screenHeight = this.height;
        int maxSize = Math.min(256, screenHeight);
        int backgroundX = (screenWidth - maxSize) / 2;
        int backgroundY = (screenHeight - maxSize) / 2;
        this.leftPos = backgroundX + (maxSize - this.guiWidth) / 2;
        this.topPos = backgroundY + (maxSize - this.guiHeight) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        boolean showClass;
        this.renderTiledBackground(guiGraphics);
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int backgroundX = screenWidth / 2 - 128;
        int backgroundY = screenHeight / 2 - 128;
        int centeredLeftPos = backgroundX + (256 - this.guiWidth) / 2;
        int centeredTopPos = backgroundY + (256 - this.guiHeight) / 2;
        int leftMargin = 60;
        int contentWidth = Math.min(this.guiWidth - 60, 200);
        String title = this.isOwnProfile ? "Your Character Profile" : this.ownerName + "'s Character Profile";
        int titleWidth = this.font.width(title);
        guiGraphics.drawString(this.font, title, centeredLeftPos + (this.guiWidth - titleWidth) / 2, centeredTopPos + 15, 4138009, false);
        int yOffset = 40;
        int textX = centeredLeftPos + 30 + leftMargin;
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_NAME_VIEWING.get()).booleanValue() && this.profile.isNameVisible()) {
            guiGraphics.drawString(this.font, "Name: " + this.profile.getName(), textX, centeredTopPos + yOffset + 4, 4138009, false);
            yOffset += 15;
        }
        boolean showAge = this.isOwnProfile || (Boolean)Config.ALLOW_AGE_VIEWING.get() != false && this.profile.isAgeVisible();
        boolean bl = showClass = this.isOwnProfile || (Boolean)Config.ALLOW_CLASS_VIEWING.get() != false && this.profile.isClassVisible();
        if (showAge || showClass) {
            if (showAge) {
                String ageText = "Age: " + this.profile.getAge();
                guiGraphics.drawString(this.font, ageText, textX, centeredTopPos + yOffset + 4, 4138009, false);
            }
            if (showClass) {
                String classText = "Class: " + this.profile.getCharacterClass();
                guiGraphics.drawString(this.font, classText, textX + 70, centeredTopPos + yOffset + 4, 4138009, false);
            }
            yOffset += 20;
        }
        if ((this.isOwnProfile || ((Boolean)Config.ALLOW_DESCRIPTION_VIEWING.get()).booleanValue() && this.profile.isDescriptionVisible()) && !this.profile.getDescription().trim().isEmpty()) {
            guiGraphics.drawString(this.font, "Description:", textX, centeredTopPos + yOffset, 4138009, false);
            int descriptionHeight = this.renderWrappedText(guiGraphics, this.profile.getDescription(), textX, centeredTopPos + (yOffset += 15), contentWidth, 4138009);
            yOffset += descriptionHeight + 15;
        }
        if (this.isOwnProfile || ((Boolean)Config.ALLOW_TRAITS_VIEWING.get()).booleanValue() && this.profile.isTraitsVisible()) {
            List<String> traits = this.profile.getTraits();
            ArrayList<String> nonEmptyTraits = new ArrayList<String>();
            for (String trait : traits) {
                if (trait.trim().isEmpty()) continue;
                nonEmptyTraits.add(trait);
            }
            if (!nonEmptyTraits.isEmpty()) {
                guiGraphics.drawString(this.font, "Traits:", textX, centeredTopPos + (yOffset += 10) - 5, 4138009, false);
                for (String trait : nonEmptyTraits) {
                    guiGraphics.drawString(this.font, "\u2022 " + trait, textX + 15, centeredTopPos + yOffset + 8, 4138009, false);
                    yOffset += 16;
                }
            }
        }
        if (!this.isOwnProfile && !this.hasVisibleContent()) {
            String noInfoMessage = "This player's profile is private.";
            int messageWidth = this.font.width(noInfoMessage);
            guiGraphics.drawString(this.font, noInfoMessage, centeredLeftPos + (this.guiWidth - messageWidth) / 2, centeredTopPos + (yOffset += 20), 0x888888, false);
        }
        yOffset += 30;
        String instruction = "Press ESC to close";
        int instructionWidth = this.font.width(instruction);
        guiGraphics.drawString(this.font, instruction, centeredLeftPos + (this.guiWidth - instructionWidth) / 2, centeredTopPos + this.guiHeight - 25, 0x666666, false);
    }

    private boolean hasVisibleContent() {
        boolean hasName = (Boolean)Config.ALLOW_NAME_VIEWING.get() != false && this.profile.isNameVisible();
        boolean hasAge = (Boolean)Config.ALLOW_AGE_VIEWING.get() != false && this.profile.isAgeVisible();
        boolean hasClass = (Boolean)Config.ALLOW_CLASS_VIEWING.get() != false && this.profile.isClassVisible() && !this.profile.getCharacterClass().trim().isEmpty();
        boolean hasDescription = (Boolean)Config.ALLOW_DESCRIPTION_VIEWING.get() != false && this.profile.isDescriptionVisible() && !this.profile.getDescription().trim().isEmpty();
        boolean hasTraits = false;
        if (((Boolean)Config.ALLOW_TRAITS_VIEWING.get()).booleanValue() && this.profile.isTraitsVisible()) {
            for (String trait : this.profile.getTraits()) {
                if (trait.trim().isEmpty()) continue;
                hasTraits = true;
                break;
            }
        }
        return hasName || hasAge || hasClass || hasDescription || hasTraits;
    }

    private void renderTiledBackground(GuiGraphics guiGraphics) {
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int drawX = screenWidth / 2 - 128;
        int drawY = screenHeight / 2 - 128;
        guiGraphics.blit(BACKGROUND_TEXTURE, drawX, drawY, 0.0f, 0.0f, 256, 256, 256, 256);
    }

    private int renderWrappedText(GuiGraphics guiGraphics, String text, int x, int y, int maxWidth, int color) {
        List<String> lines = this.wrapText(text, maxWidth);
        for (int i = 0; i < lines.size(); ++i) {
            guiGraphics.drawString(this.font, lines.get(i), x, y + i * 10, color, false);
        }
        return lines.size() * 10;
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : String.valueOf(currentLine) + " " + word;
            if (this.font.width(testLine) <= maxWidth) {
                currentLine = new StringBuilder(testLine);
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return true;
    }
}

