/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.nethanialchorus.profiles.Config;
import com.nethanialchorus.profiles.network.ProfileNetworkHandler;
import com.nethanialchorus.profiles.profile.CharacterProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;

public class ProfileCommands {
    private static final Map<UUID, ProfileCreationData> creationData = new HashMap<UUID, ProfileCreationData>();

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"profile").executes(ProfileCommands::openOwnProfile)).then(((LiteralArgumentBuilder)Commands.literal((String)"create").executes(ProfileCommands::startProfileCreation)).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> ProfileCommands.quickCreateProfile((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(Commands.literal((String)"set").then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.greedyString()).executes(ProfileCommands::setProfileValue)))).then(Commands.literal((String)"confirm").executes(ProfileCommands::confirmProfileCreation))).then(Commands.literal((String)"cancel").executes(ProfileCommands::cancelProfileCreation))).then(Commands.literal((String)"lookup").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(ProfileCommands::lookupProfile))));
    }

    private static int startProfileCreation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (CharacterProfile.hasProfile(player)) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You already have a character profile! Use " + String.valueOf(ChatFormatting.GOLD) + "/profile " + String.valueOf(ChatFormatting.RED) + "to view it.")));
            return 0;
        }
        creationData.put(player.getUUID(), new ProfileCreationData());
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "=== Character Profile Creation ===")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 1/5: Enter your character's name")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <name>")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Cancel anytime with: " + String.valueOf(ChatFormatting.GOLD) + "/profile cancel")));
        return 1;
    }

    private static int quickCreateProfile(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (CharacterProfile.hasProfile(player)) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You already have a character profile! Use " + String.valueOf(ChatFormatting.GOLD) + "/profile " + String.valueOf(ChatFormatting.RED) + "to view it.")));
            return 0;
        }
        if (name.length() > (Integer)Config.MAX_NAME_LENGTH.get()) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Character name is too long! Maximum " + String.valueOf(Config.MAX_NAME_LENGTH.get()) + " characters.")));
            return 0;
        }
        if (name.trim().isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Character name cannot be empty!")));
            return 0;
        }
        ProfileCreationData creation = new ProfileCreationData();
        creation.name = name.trim();
        creation.step = 2;
        creationData.put(player.getUUID(), creation);
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "=== Character Profile Creation ===")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Name set to: " + String.valueOf(ChatFormatting.WHITE) + name)));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 2/5: Enter your character's age")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <age>")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "(Age range: " + String.valueOf(Config.MIN_AGE.get()) + "-" + String.valueOf(Config.MAX_AGE.get()) + ")")));
        return 1;
    }

    private static int confirmProfileCreation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ProfileCreationData creation = creationData.get(player.getUUID());
        if (creation == null) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "No active profile creation. Use " + String.valueOf(ChatFormatting.GOLD) + "/profile create " + String.valueOf(ChatFormatting.RED) + "to start.")));
            return 0;
        }
        if (!creation.isComplete()) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Profile creation is not complete. Continue with " + String.valueOf(ChatFormatting.GOLD) + "/profile set <value>")));
            return 0;
        }
        CharacterProfile profile = new CharacterProfile(player.getUUID(), creation.name, creation.age, creation.description);
        profile.setCharacterClass(creation.characterClass);
        profile.setTraits(creation.traits);
        CharacterProfile.setProfile(player, profile);
        creationData.remove(player.getUUID());
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "Character profile created successfully!")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Use " + String.valueOf(ChatFormatting.GOLD) + "/profile " + String.valueOf(ChatFormatting.YELLOW) + "to view and edit your profile anytime.")));
        return 1;
    }

    private static int openOwnProfile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!CharacterProfile.hasProfile(player)) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "You don't have a character profile yet!")));
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Use " + String.valueOf(ChatFormatting.GOLD) + "/profile create " + String.valueOf(ChatFormatting.YELLOW) + "for a guided setup or " + String.valueOf(ChatFormatting.GOLD) + "/profile create <name> " + String.valueOf(ChatFormatting.YELLOW) + "for quick creation.")));
            return 0;
        }
        CharacterProfile profile = CharacterProfile.getProfile(player).orElse(null);
        if (profile != null) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new ProfileNetworkHandler.OpenProfileGuiPacket(profile, true, player.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return 1;
    }

    private static int lookupProfile(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer requester = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(context, (String)"player");
        if (!CharacterProfile.hasProfile(target)) {
            requester.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + target.getDisplayName().getString() + " doesn't have a character profile.")));
            return 0;
        }
        CharacterProfile profile = CharacterProfile.getProfile(target).orElse(null);
        if (profile == null) {
            requester.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Error retrieving profile.")));
            return 0;
        }
        CharacterProfile filteredProfile = profile.createFilteredProfile(requester.getUUID().equals(target.getUUID()));
        PacketDistributor.sendToPlayer((ServerPlayer)requester, (CustomPacketPayload)new ProfileNetworkHandler.OpenProfileGuiPacket(filteredProfile, false, target.getUUID()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        return 1;
    }

    private static int setProfileValue(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String value = StringArgumentType.getString(context, (String)"value");
        ProfileCreationData creation = creationData.get(player.getUUID());
        if (creation == null) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "No active profile creation. Use " + String.valueOf(ChatFormatting.GOLD) + "/profile create " + String.valueOf(ChatFormatting.RED) + "to start.")));
            return 0;
        }
        switch (creation.step) {
            case 1: {
                if (value.length() > (Integer)Config.MAX_NAME_LENGTH.get()) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Name too long! Maximum " + String.valueOf(Config.MAX_NAME_LENGTH.get()) + " characters.")));
                    return 0;
                }
                if (value.trim().isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Name cannot be empty!")));
                    return 0;
                }
                creation.name = value.trim();
                creation.step = 2;
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Name set to: " + String.valueOf(ChatFormatting.WHITE) + creation.name)));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 2/5: Enter your character's age")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <age>")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "(Age range: " + String.valueOf(Config.MIN_AGE.get()) + "-" + String.valueOf(Config.MAX_AGE.get()) + ")")));
                break;
            }
            case 2: {
                try {
                    int age = Integer.parseInt(value);
                    if (age < (Integer)Config.MIN_AGE.get() || age > (Integer)Config.MAX_AGE.get()) {
                        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Age must be between " + String.valueOf(Config.MIN_AGE.get()) + " and " + String.valueOf(Config.MAX_AGE.get()))));
                        return 0;
                    }
                    creation.age = age;
                    creation.step = 3;
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Age set to: " + String.valueOf(ChatFormatting.WHITE) + age)));
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 3/5: Enter your character's description")));
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <description>")));
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "(Maximum " + String.valueOf(Config.MAX_DESCRIPTION_LENGTH.get()) + " characters)")));
                    break;
                }
                catch (NumberFormatException e) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Please enter a valid number for age.")));
                    return 0;
                }
            }
            case 3: {
                if (value.length() > (Integer)Config.MAX_DESCRIPTION_LENGTH.get()) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Description too long! Maximum " + String.valueOf(Config.MAX_DESCRIPTION_LENGTH.get()) + " characters.")));
                    return 0;
                }
                creation.description = value;
                creation.step = 4;
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Description set.")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 4/5: Enter your character's class")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <class>")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "(Example: Warrior, Mage, Rogue, etc. Maximum " + String.valueOf(Config.MAX_CLASS_LENGTH.get()) + " characters)")));
                break;
            }
            case 4: {
                if (value.length() > (Integer)Config.MAX_CLASS_LENGTH.get()) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Class too long! Maximum " + String.valueOf(Config.MAX_CLASS_LENGTH.get()) + " characters.")));
                    return 0;
                }
                creation.characterClass = value;
                creation.step = 5;
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Class set to: " + String.valueOf(ChatFormatting.WHITE) + value)));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Step 5/5: Enter your character's traits")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Use: " + String.valueOf(ChatFormatting.GOLD) + "/profile set <trait>")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Enter one trait at a time. You can add up to 5 traits.")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Current traits: " + creation.traits.size() + "/5")));
                break;
            }
            case 5: {
                if (creation.traits.size() >= 5) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Maximum 5 traits allowed! Use " + String.valueOf(ChatFormatting.GOLD) + "/profile confirm " + String.valueOf(ChatFormatting.RED) + "to finish.")));
                    return 0;
                }
                String trait = value.trim();
                if (trait.isEmpty()) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Trait cannot be empty!")));
                    return 0;
                }
                if (trait.length() > 50) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Trait too long! Maximum 50 characters per trait.")));
                    return 0;
                }
                creation.traits.add(trait);
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Added trait: " + String.valueOf(ChatFormatting.WHITE) + trait)));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Current traits (" + creation.traits.size() + "/5): " + String.valueOf(ChatFormatting.WHITE) + String.join((CharSequence)", ", creation.traits))));
                if (creation.traits.size() >= 5) {
                    player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Maximum traits reached! Use " + String.valueOf(ChatFormatting.GOLD) + "/profile confirm " + String.valueOf(ChatFormatting.YELLOW) + "to finish.")));
                    ProfileCommands.showProfileSummary(player, creation);
                    break;
                }
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Add another trait with " + String.valueOf(ChatFormatting.GOLD) + "/profile set <trait>")));
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Or finish with " + String.valueOf(ChatFormatting.GOLD) + "/profile confirm")));
                break;
            }
            default: {
                player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "Invalid step in profile creation.")));
                return 0;
            }
        }
        return 1;
    }

    private static void showProfileSummary(ServerPlayer player, ProfileCreationData creation) {
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GREEN) + "=== Profile Summary ===")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Name: " + String.valueOf(ChatFormatting.WHITE) + creation.name)));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Age: " + String.valueOf(ChatFormatting.WHITE) + creation.age)));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Class: " + String.valueOf(ChatFormatting.WHITE) + creation.characterClass)));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Description: " + String.valueOf(ChatFormatting.WHITE) + creation.description)));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "Traits:")));
        for (int i = 0; i < creation.traits.size(); ++i) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "  * " + String.valueOf(ChatFormatting.WHITE) + creation.traits.get(i))));
        }
        player.sendSystemMessage((Component)Component.literal((String)""));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Confirm creation with " + String.valueOf(ChatFormatting.GOLD) + "/profile confirm")));
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Or cancel with " + String.valueOf(ChatFormatting.GOLD) + "/profile cancel")));
    }

    private static int cancelProfileCreation(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ProfileCreationData creation = creationData.remove(player.getUUID());
        if (creation == null) {
            player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "No active profile creation to cancel.")));
            return 0;
        }
        player.sendSystemMessage((Component)Component.literal((String)(String.valueOf(ChatFormatting.YELLOW) + "Profile creation cancelled.")));
        return 1;
    }

    private static CharacterProfile createFilteredProfile(CharacterProfile original, boolean isOwnProfile) {
        if (isOwnProfile) {
            return original;
        }
        CharacterProfile filtered = new CharacterProfile(original.getPlayerUUID(), (Boolean)Config.ALLOW_NAME_VIEWING.get() != false ? original.getName() : "[Hidden]", (Boolean)Config.ALLOW_AGE_VIEWING.get() != false ? original.getAge() : 0, (Boolean)Config.ALLOW_DESCRIPTION_VIEWING.get() != false ? original.getDescription() : "[Hidden]");
        filtered.setCharacterClass((Boolean)Config.ALLOW_CLASS_VIEWING.get() != false ? original.getCharacterClass() : "[Hidden]");
        if (((Boolean)Config.ALLOW_TRAITS_VIEWING.get()).booleanValue()) {
            filtered.setTraits(original.getTraits());
        } else {
            ArrayList<String> hiddenTraits = new ArrayList<String>();
            hiddenTraits.add("[Hidden]");
            filtered.setTraits(hiddenTraits);
        }
        return filtered;
    }

    private static class ProfileCreationData {
        String name;
        Integer age;
        String description;
        String characterClass;
        List<String> traits = new ArrayList<String>();
        int step = 1;

        private ProfileCreationData() {
        }

        boolean isComplete() {
            return this.name != null && this.age != null && this.description != null && this.characterClass != null && this.traits != null;
        }
    }
}

