/*
 * Decompiled with CFR 0.152.
 */
package com.nethanialchorus.profiles.network;

import com.nethanialchorus.profiles.client.ClientProfileData;
import com.nethanialchorus.profiles.client.gui.CharacterProfileScreen;
import com.nethanialchorus.profiles.client.gui.CharacterProfileViewScreen;
import com.nethanialchorus.profiles.profile.CharacterProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ProfileNetworkHandler {
    public static final ResourceLocation OPEN_PROFILE_GUI_ID = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"open_profile_gui");
    public static final ResourceLocation UPDATE_PROFILE_ID = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"update_profile");
    public static final ResourceLocation SYNC_PROFILE_ID = ResourceLocation.fromNamespaceAndPath((String)"characterprofiles", (String)"sync_profile");

    public record SyncProfilePacket(CharacterProfile profile) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<SyncProfilePacket> TYPE = new CustomPacketPayload.Type(SYNC_PROFILE_ID);
        public static final StreamCodec<FriendlyByteBuf, SyncProfilePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
            if (packet.profile() != null) {
                buf.writeBoolean(true);
                buf.writeUtf(packet.profile().getName());
                buf.writeInt(packet.profile().getAge());
                buf.writeUtf(packet.profile().getDescription());
                buf.writeUtf(packet.profile().getCharacterClass());
                List<String> traits = packet.profile().getTraits();
                buf.writeInt(traits.size());
                for (String trait : traits) {
                    buf.writeUtf(trait);
                }
                buf.writeBoolean(packet.profile().isNameVisible());
                buf.writeBoolean(packet.profile().isAgeVisible());
                buf.writeBoolean(packet.profile().isDescriptionVisible());
                buf.writeBoolean(packet.profile().isClassVisible());
                buf.writeBoolean(packet.profile().isTraitsVisible());
                UUIDUtil.STREAM_CODEC.encode(buf, (Object)packet.profile().getPlayerUUID());
            } else {
                buf.writeBoolean(false);
            }
        }, buf -> {
            if (buf.readBoolean()) {
                String name = buf.readUtf();
                int age = buf.readInt();
                String description = buf.readUtf();
                String characterClass = buf.readUtf();
                int traitsCount = buf.readInt();
                ArrayList<String> traits = new ArrayList<String>();
                for (int i = 0; i < traitsCount; ++i) {
                    traits.add(buf.readUtf());
                }
                boolean nameVisible = buf.readBoolean();
                boolean ageVisible = buf.readBoolean();
                boolean descriptionVisible = buf.readBoolean();
                boolean classVisible = buf.readBoolean();
                boolean traitsVisible = buf.readBoolean();
                UUID playerUUID = (UUID)UUIDUtil.STREAM_CODEC.decode(buf);
                CharacterProfile profile = new CharacterProfile(playerUUID, name, age, description, characterClass, traits, nameVisible, ageVisible, descriptionVisible, classVisible, traitsVisible);
                return new SyncProfilePacket(profile);
            }
            return new SyncProfilePacket(null);
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(SyncProfilePacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                if (packet.profile() != null) {
                    ClientProfileData.setProfile(packet.profile());
                } else {
                    ClientProfileData.clearProfile();
                }
            });
        }
    }

    public record UpdateProfilePacket(String name, int age, String description, String characterClass, List<String> traits, boolean nameVisible, boolean ageVisible, boolean descriptionVisible, boolean classVisible, boolean traitsVisible) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<UpdateProfilePacket> TYPE = new CustomPacketPayload.Type(UPDATE_PROFILE_ID);
        public static final StreamCodec<FriendlyByteBuf, UpdateProfilePacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
            buf.writeUtf(packet.name());
            buf.writeInt(packet.age());
            buf.writeUtf(packet.description());
            buf.writeUtf(packet.characterClass());
            buf.writeInt(packet.traits().size());
            for (String trait : packet.traits()) {
                buf.writeUtf(trait);
            }
            buf.writeBoolean(packet.nameVisible());
            buf.writeBoolean(packet.ageVisible());
            buf.writeBoolean(packet.descriptionVisible());
            buf.writeBoolean(packet.classVisible());
            buf.writeBoolean(packet.traitsVisible());
        }, buf -> {
            String name = buf.readUtf();
            int age = buf.readInt();
            String description = buf.readUtf();
            String characterClass = buf.readUtf();
            int traitsCount = buf.readInt();
            ArrayList<String> traits = new ArrayList<String>();
            for (int i = 0; i < traitsCount; ++i) {
                traits.add(buf.readUtf());
            }
            boolean nameVisible = buf.readBoolean();
            boolean ageVisible = buf.readBoolean();
            boolean descriptionVisible = buf.readBoolean();
            boolean classVisible = buf.readBoolean();
            boolean traitsVisible = buf.readBoolean();
            return new UpdateProfilePacket(name, age, description, characterClass, traits, nameVisible, ageVisible, descriptionVisible, classVisible, traitsVisible);
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(UpdateProfilePacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                    CharacterProfile.getProfile(serverPlayer).ifPresent(profile -> {
                        profile.setName(packet.name());
                        profile.setAge(packet.age());
                        profile.setDescription(packet.description());
                        profile.setCharacterClass(packet.characterClass());
                        profile.setTraits(packet.traits());
                        profile.setNameVisible(packet.nameVisible());
                        profile.setAgeVisible(packet.ageVisible());
                        profile.setDescriptionVisible(packet.descriptionVisible());
                        profile.setClassVisible(packet.classVisible());
                        profile.setTraitsVisible(packet.traitsVisible());
                        CharacterProfile.setProfile(serverPlayer, profile);
                    });
                }
            });
        }
    }

    public record OpenProfileGuiPacket(CharacterProfile profile, boolean isOwnProfile, UUID targetPlayerUUID) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<OpenProfileGuiPacket> TYPE = new CustomPacketPayload.Type(OPEN_PROFILE_GUI_ID);
        public static final StreamCodec<FriendlyByteBuf, OpenProfileGuiPacket> STREAM_CODEC = StreamCodec.of((buf, packet) -> {
            buf.writeUtf(packet.profile().getName());
            buf.writeInt(packet.profile().getAge());
            buf.writeUtf(packet.profile().getDescription());
            buf.writeUtf(packet.profile().getCharacterClass());
            List<String> traits = packet.profile().getTraits();
            buf.writeInt(traits.size());
            for (String trait : traits) {
                buf.writeUtf(trait);
            }
            buf.writeBoolean(packet.profile().isNameVisible());
            buf.writeBoolean(packet.profile().isAgeVisible());
            buf.writeBoolean(packet.profile().isDescriptionVisible());
            buf.writeBoolean(packet.profile().isClassVisible());
            buf.writeBoolean(packet.profile().isTraitsVisible());
            UUIDUtil.STREAM_CODEC.encode(buf, (Object)packet.profile().getPlayerUUID());
            buf.writeBoolean(packet.isOwnProfile());
            UUIDUtil.STREAM_CODEC.encode(buf, (Object)packet.targetPlayerUUID());
        }, buf -> {
            String name = buf.readUtf();
            int age = buf.readInt();
            String description = buf.readUtf();
            String characterClass = buf.readUtf();
            int traitsCount = buf.readInt();
            ArrayList<String> traits = new ArrayList<String>();
            for (int i = 0; i < traitsCount; ++i) {
                traits.add(buf.readUtf());
            }
            boolean nameVisible = buf.readBoolean();
            boolean ageVisible = buf.readBoolean();
            boolean descriptionVisible = buf.readBoolean();
            boolean classVisible = buf.readBoolean();
            boolean traitsVisible = buf.readBoolean();
            UUID playerUUID = (UUID)UUIDUtil.STREAM_CODEC.decode(buf);
            boolean isOwnProfile = buf.readBoolean();
            UUID targetPlayerUUID = (UUID)UUIDUtil.STREAM_CODEC.decode(buf);
            CharacterProfile profile = new CharacterProfile(playerUUID, name, age, description, characterClass, traits, nameVisible, ageVisible, descriptionVisible, classVisible, traitsVisible);
            return new OpenProfileGuiPacket(profile, isOwnProfile, targetPlayerUUID);
        });

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE;
        }

        public static void handle(OpenProfileGuiPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                if (!packet.isOwnProfile) {
                    Minecraft.getInstance().setScreen((Screen)new CharacterProfileViewScreen(packet.profile, packet.isOwnProfile(), packet.profile.getName()));
                } else {
                    Minecraft.getInstance().setScreen((Screen)new CharacterProfileScreen(packet.profile(), packet.isOwnProfile()));
                }
            });
        }
    }
}

